#include "Tutorial/Exercise/interface/ParentProducer.h"
using namespace std;
ParentProducer::ParentProducer(const edm::ParameterSet& cfg) {

  // need to tell it what it produces
  // otherwise I get an "Illegal attempt to 'put' an unregistered product."
  // error
   produces<std::vector<reco::LeafCandidate> >();

   // get parameters from config file (in Tutorial/Exercise/python)
   min_pt = cfg.getParameter<double>("muonPt");
   max_eta = cfg.getParameter<double>("muonEta");
   

}

ParentProducer::~ParentProducer() {}

void ParentProducer::produce(edm::Event& event, const edm::EventSetup& setup) {


    // results go here
  std::auto_ptr<std::vector<reco::LeafCandidate> > parentCollection(new std::vector<reco::LeafCandidate>);


  // get muons
  edm::Handle<reco::MuonCollection> muon_handle;
  event.getByLabel("muons",muon_handle);
  
  // the filter has run before hand, so I have at least two muons
  // why does every experiment have a different way to access what is basically a bunch of fourvectors on speed ?!

  // const float min_pt = 5.0;
  //const float max_eta = 3.0;

  // HACK: commented out while used as MC checker
  if ( muon_handle->size() < 2) {std::cout << "HELP: Wrong number of muons !!" << std::endl;}

  for (unsigned int i = 0; i < muon_handle->size(); ++i) {
    // see what I've got:
     reco::MuonRef muon_tmp(muon_handle, i);
     // cout <<  "(" << i << ") " << muon_tmp->px() << "\t" << muon_tmp->py() << "\t" << muon_tmp->pz() << endl;

    for (unsigned int ii = i+1; ii <  muon_handle->size(); ++ii) {
      // sigh
      reco::MuonRef muon_1(muon_handle, i);
      reco::MuonRef muon_2(muon_handle, ii);
      if ( (muon_1->charge() * muon_2->charge()) < 0) {
	if (muon_1->pt() > min_pt && std::abs(muon_1->eta()) < max_eta) {
	  if (muon_2->pt() > min_pt && std::abs(muon_2->eta()) < max_eta) {
	    // LeafCandidate( Charge q, const LorentzVector & p4, const Point & vtx = Point( 0, 0, 0 ), [etc]
	    // std::cout << "Found parent candidate" << std::endl;
	    parentCollection->push_back(reco::LeafCandidate(0, muon_1->p4()+muon_2->p4()));
	    
	  } // muon_2
	} // muon_1
      } // charge
    } // for ii
  } // for i

  //  if (parentCollection->size() > 0) {
  //  std::cout << "parentCollection->size(): " << parentCollection->size() << std::endl;
  // }
  event.put(parentCollection);	
          
}

DEFINE_FWK_MODULE(ParentProducer);
