#!/usr/bin/env python
"""
_ConfigTools_

Interim tools for extracting information from the PSet Config
python dictionary.

Eventually the content of this module should be replaced with the
official cmsconfig tool currently under development

"""

from ProdCommon.CMSConfigTools.cmsconfig import cmsconfig

def expandPSetDetails(jobSpecNode):
    """
    _expandPSetDetails_

    Extract details of Input and Output modules from the PSet configuration
    embedded in the JobSpecNode instance provided

    """
    config = jobSpecNode.configuration
    try:
        pset = cmsconfig(config)
    except StandardError, ex:
        # cant read PSet, give up and return
        return


    #  //
    # // Process the output modules
    #//
    for item in pset.outputModuleNames():
        modDict =  pset.module(item)
        outMod = jobSpecNode.newOutputModule()
        
        outMod["ModuleType"] = modDict['@classname'][2]
        outMod["ModuleName"] = item
        if modDict.has_key("Catalog"):
            outMod["OutputCatalog"] = modDict['Catalog'][2]


        #  //
        # // Multiple fileName and logicalFileNames are not permitted
        #//  in the OutputModules, if multiple pfns/lfns are generated
        #  //by the framework exe, then they are autogenerated from
        # // those specified in the PSet:
        #//  PFNs:
        #  //file:myFile.root => file:myFile000.root, file:myFile001.root, etc
        # // LFNs:
        #//
        #  //myLogicalFile => myLogicalFile000, myLogicalFile001, etc
        # //
        #//
        pfns = []
        if modDict.has_key("fileName"):
            pfns.append(modDict['fileName'][2])
            
        for pfn in pfns:
            outMod["PhysicalFileNames"].append(pfn)
            
            
        lfns = []
        if modDict.has_key("logicalFileName"):
            lfns.append(modDict['logicalFileName'][2])
                       
        for lfn in lfns:
            outMod["LogicalFileNames"].append(lfn)


    #  //
    # // Process the input source
    #// 
    source = pset.mainInputSource()
    inpMod = jobSpecNode.inputModule
    inpMod['ModuleType'] = source['@classname'][2]
    if source.has_key('maxEvents'):
        inpMod['MaxEvents'] = source['maxEvents'][2]

    if source.has_key('Catalog'):
        inpMod['Catalog'] = source['Catalog'][2]

    inputFiles = []
    #  //
    # // Input source input filenames can be single file or vector of
    #//  input filenames.
    #  //If the file doesnt start with a file: it is assumed to be
    # // an LFN by the framework and a catalog lookup is performed
    #//
    if source.has_key('fileName'):
        inputFiles.append(source['fileName'][2])
    if source.has_key('fileNames'):
        inputFiles.extend(source['fileName'][2])

    for inpFile in inputFiles:
        inpMod["InputFiles"].append(inpFile)
    
    
    
    
        
    return
    
    
        
