#ifndef TrgReadout_HH
#define TrgReadout_HH

#include <iostream>
#include <fstream>

#include "RcdHeader.hh"
#include "RcdUserRW.hh"

#include "DaqRunStart.hh"
#include "CrcBeTrgEventData.hh"
#include "SubAccessor.hh"
#include "SubInserter.hh"


class TrgReadout : public RcdUserRW {

public:
  TrgReadout(unsigned, unsigned char, unsigned char) {
  }

  virtual ~TrgReadout() {
  }

  virtual bool record(RcdRecord &r) {
    if(doPrint(r.recordType())) {
      std::cout << std::endl << "TrgReadout::record()" << std::endl;
      r.RcdHeader::print(std::cout," ") << std::endl;
    }

    if(r.recordType()==RcdHeader::runStart) {

      // Access the DaqRunStart to get print level
      SubAccessor accessor(r);
      std::vector<const DaqRunStart*> v(accessor.extract<DaqRunStart>());
      assert(v.size()==1);
      if(doPrint(r.recordType(),1)) v[0]->print(std::cout," ") << std::endl;

      _printLevel=v[0]->runType().printLevel();
    }

    /*
    if(r.recordType()==RcdHeader::configurationStart) {
      SubAccessor accessor(r);
      std::vector<const CrcLocationData<CrcBeTrgConfigurationData>*>
	v(accessor.extract< CrcLocationData<CrcBeTrgConfigurationData> >());

      if(doPrint(r.recordType(),1)) {
	std::cout << " Number of CrcBeTrgConfigurationData subrecords accessed = "
		  << v.size() << std::endl;
	for(unsigned i(0);i<v.size();i++) {
	  v[i]->print(std::cout," ") << std::endl;
	}
      }
    }
    */

    if(r.recordType()==RcdHeader::spill) {
      SubInserter inserter(r);
      CrcLocationData<CrcBeTrgEventData> *c(inserter.insert< CrcLocationData<CrcBeTrgEventData> >(true));
      c->data()->triggerCounter(123);
    }

    return true;
  }
};

#endif
