#ifndef AhcReadoutV0_HH
#define AhcReadoutV0_HH

#include <iostream>
#include <fstream>

#include "CrcReadout.hh"


class AhcReadoutV0 : public CrcReadout {

public:
  AhcReadoutV0() : CrcReadout() {
  }

  AhcReadoutV0(unsigned char c) : CrcReadout(c) {
  }

  virtual ~AhcReadoutV0() {
  }

  bool writeFeConfigurationData(RcdRecord &r) {
    SubAccessor accessor(r);

    std::vector<const CrcLocationData<AhcFeConfigurationDataV0>*>
      femc(accessor.access< CrcLocationData<AhcFeConfigurationDataV0> >());
    
    for(unsigned j(0);j<femc.size();j++) {
      if(femc[j]->crateNumber()==_crateNumber &&
	 _device[femc[j]->slotNumber()]!=0 &&
	 _feEnable[femc[j]->slotNumber()][femc[j]->componentNumber()]) {
	
	if(_printLevel>2) femc[j]->print(std::cout);
	assert(_device[femc[j]->slotNumber()]->writeAhcFeConfigurationData(femc[j]->crcComponent(),*femc[j]->data()));
      }
    }

    return true;
  }

  bool readFeConfigurationData(RcdRecord &r) {
    SubInserter inserter(r);

    for(unsigned i(0);i<=21;i++) {
      if(_device[i]!=0) {
	CrcLocation cl(_crateNumber,_device[i]->slot(),CrcLocation::vme);

	for(unsigned f(0);f<8;f++) {
	  if(_feEnable[i][f]) {
	    cl.crcComponent((CrcLocation::CrcComponent)f);
	    CrcLocationData<AhcFeConfigurationDataV0>
	      *e(inserter.insert< CrcLocationData<AhcFeConfigurationDataV0> >());
	    e->location(cl);
	    _device[i]->readAhcFeConfigurationData(cl.crcComponent(),*e->data());
	    if(_printLevel>2) e->print(std::cout);
	  }
	} 
      }
    }

    return true;
  }

private:
};

#endif
