#ifndef BmlHodReadout_HH
#define BmlHodReadout_HH

#include <string>
#include <iostream>

#include "RcdRecord.hh"
#include "SubInserter.hh"

#include "BmlHodRunData.hh"
#include "BmlHodEventData.hh"
#include "BmlHodUsbDevice.hh"


class BmlHodReadout {

public:
  enum Port {
    query='?',portA='A',portB,portC,porta='a',portb,portc
  };

  BmlHodReadout(BmlHodUsbDevice &d) : _driver(d) {
    setup();
    reset();
    
    unsigned char buffer[3]={'?','\r','\n'};
    if(_driver.write(3,buffer)) {
      unsigned char readBuffer[13];
      readBuffer[_driver.read(readBuffer)]='\0';
      std::cout << "BmlHodReadout::ctor()  version = " << readBuffer << std::endl;
    }
  }

  void record(RcdRecord &r) {

    // Check record type
    switch (r.recordType()) {

    // Run start and end are treated the same
    case RcdHeader::runStart: {
      //case RcdHeader::runEnd:
      //case RcdHeader::runStop: { Causes a crash?

      SubInserter inserter(r);
      assert(reset());
      
      BmlHodRunData *d(inserter.insert<BmlHodRunData>());
      assert(readRunData(*d));
      
      break;
    }

      
    case RcdHeader::event: {

      SubInserter inserter(r);
      
      BmlHodEventData *b(inserter.insert<BmlHodEventData>());
      assert(readEventData(*b));
      
      break;
    }

    default: {
      break;
    }
    };
  }

  bool readRunData(BmlHodRunData &d) {
    unsigned char buffer[3]={'?','\r','\n'};

    if(!_driver.write(3,buffer)) return false;

    unsigned char *dataBuffer(d.data());
    unsigned n(_driver.read(dataBuffer));
    d.numberOfBytes(n);

    return true;
  }

  bool setup() {
    unsigned char buffer[5]={'!',portA,0xff,'\r','\n'};
    if(!_driver.write(5,buffer)) return false;
    
    buffer[1]=portB;
    if(!_driver.write(5,buffer)) return false;
    
    buffer[1]=portC;
    buffer[2]=0xf8; // 0x08?
    if(!_driver.write(5,buffer)) return false;
    
    return true;
  }
  
  bool reset() {
    if(!write(portC,0x01)) return false;
    if(!write(portC,0x00)) return false;
    return true;
  }

  bool triggerPoll(unsigned n=0) {
    for(unsigned i(0);i<n || n==0;i++) {
      if((read(portc)&0x08)==0) return true;
    }
    return false;
  }
  
  bool readEventData(BmlHodEventData &d) {
    unsigned short data[4];
    unsigned char c(read(portc)&0xf9);
    
    write(portC,c|0x00);
    data[0]=(read(porta)<<8)+read(portb);
    write(portC,c|0x02);
    data[1]=(read(porta)<<8)+read(portb);
    write(portC,c|0x04);
    data[2]=(read(porta)<<8)+read(portb);
    write(portC,c|0x06);
    data[3]=(read(porta)<<8)+read(portb);

    d=BmlHodEventData(data);
    return true;
  }
  
  unsigned char write(Port p, unsigned char c) {
    unsigned char buffer[4]={p,c,'\r','\n'};
    return _driver.write(4,buffer);
  }
  
  unsigned char read(Port p) {
    unsigned char readBuffer(0x00);
    unsigned char buffer[3]={p,'\r','\n'};
    if(_driver.write(3,buffer)) {
      _driver.read(1,&readBuffer);
    }

    return readBuffer;
  }
  

private:
  BmlHodUsbDevice &_driver;
};

#endif
