#ifndef CercVmeSerialCommandP_HH
#define CercVmeSerialCommandP_HH

#include <iostream>
#include <cstring>

#include "CercVmeSerialHeader.hh"


template <class Payload>
class CercVmeSerialCommandP : public CercVmeSerialHeader {

public:
  CercVmeSerialCommandP(Target t, Designator d)
    : CercVmeSerialHeader(t,d,8*sizeof(Payload)) {
    memset(_data,0,(sizeof(Payload)+3)/4);
  }

  Payload* payload() {
    return (Payload*)_data;
  }

  void print(std::ostream& o, std::string s="") const {
    o << s << "CercVmeSerialCommandP" << std::endl;
    CercVmeSerialHeader::print(o,s+" ");
    for(unsigned i(0);i<(sizeof(Payload)+3)/4;i++) {
      o << s << " Data word " << setw(4) << i << " = "
	<< setw(10) << printHex(_data[i]) << std::endl;
    }
  }


protected:
  unsigned _data[(sizeof(Payload)+3)/4];
};

#endif
