#ifndef CrcSerialCommandShort_HH
#define CrcSerialCommandShort_HH

#include "CrcSerialCommand.hh"

class CrcSerialCommandShort : public CrcSerialCommand<16> {

public:
  CrcSerialCommandShort(Target t, Designator d)
    : CrcSerialCommand<16>(t,d) {
  }

  unsigned short data() const {
    return _data[0]>>16;
  }

  void data(unsigned short d) {
    _data[0]=(d<<16);
  }
};

#endif
