#ifndef DaqCommander_HH
#define DaqCommander_HH

#include <vector>
#include <fstream>
#include <iostream>

// dual/inc/rcd
#include "RcdUserRW.hh"
#include "DaqStateData.hh"
#include "SubAccessor.hh"
#include "SubModifier.hh"
#include "SubInserter.hh"

#include "DvrDaq.hh"




class DaqCommander : public RcdUserRW {

public:
  DaqCommander() {
    _dsd.stateMachine(DaqStateData::medium);
    _dsd.initialState(0);

    _dvrDaq.printLevel(9);
  }

  virtual ~DaqCommander() {
  }

  bool record(RcdRecord &r) {
    SubInserter inserter(r);

    // Check record type
    switch (_dsd.initialState()) {
      
    case 0: {
      r.initialise(RcdHeader::startUp);
      _dsd.finalState(1);

      DaqStartUp dsu;
      dsu.maximumNumberOfRunsInJob(1);
      inserter.insert<DaqStartUp>(dsu);
      dsu.print(std::cout);
      break;
    }

    case 1: {
      if(_dvrDaq.endJob()) {
	r.initialise(RcdHeader::shutdown);
	_dsd.finalState(0);
	break;
      }

      r.initialise(RcdHeader::runStart);
      _dsd.finalState(2);
      break;
    }

    case 2: {
      r.initialise(RcdHeader::slowControl);
      _dsd.finalState(3);
      break;
    }

    case 3: {
      if(_dvrDaq.endRun()) {
	r.initialise(RcdHeader::runEnd);
	_dsd.finalState(1);
	break;
      } 

      if(_dvrDaq.stopRun()) {
	r.initialise(RcdHeader::runStop);
	_dsd.finalState(1);
	break;
      }

      r.initialise(RcdHeader::configurationStart);
      _dsd.finalState(4);
      break;
    }

    case 4: {
      if(_dvrDaq.endConfiguration()) {
	r.initialise(RcdHeader::configurationEnd);
	_dsd.finalState(3);
	break;
      }

      if(_dvrDaq.stopConfiguration()) {
	r.initialise(RcdHeader::configurationStop);
	_dsd.finalState(3);
	break;
      }

      if(_dvrDaq.readoutMode()==0) {
	r.initialise(RcdHeader::preEvent);
	_dsd.finalState(5);
      } else {
	r.initialise(RcdHeader::spillStart);
	_dsd.finalState(6);
      }

      //r.initialise(RcdHeader::slowReadout);
      //_dsd.finalState(4);

      break;
    }

    case 5: {
      r.initialise(RcdHeader::event);
      _dsd.finalState(4);
      break;
    }

    case 6: {
      if(_dvrDaq.readoutMode()==2) {
	r.initialise(RcdHeader::spillEnd);
	_dsd.finalState(7);
	break;
      } 

      if(_dvrDaq.endSpill()) {
	r.initialise(RcdHeader::spillEnd);
	_dsd.finalState(7);
	break;
      } 

      if(_dvrDaq.stopSpill()) {
	r.initialise(RcdHeader::spillStop);
	_dsd.finalState(7);
	break;
      }

      r.initialise(RcdHeader::preEvent);
      _dsd.finalState(6);
      break;
    }

    case 7: {
      if(_dvrDaq.endBuffer()) {
	r.initialise(RcdHeader::bufferEnd);
	_dsd.finalState(4);
	break;
      } 

      if(_dvrDaq.stopBuffer()) {
	r.initialise(RcdHeader::bufferStop);
	_dsd.finalState(4);
	break;
      }

      r.initialise(RcdHeader::event);
      _dsd.finalState(7);
      break;
    }

    default: {
      assert(false);
      break;
    }
    };

    std::cout << std::endl << "States and generated transition" << std::endl;
    _dsd.print(std::cout);
    r.RcdHeader::print(std::cout); 
   
    _dvrDaq.record(r);

    _dsd.initialState(_dsd.finalState());

    return true;
  }
  
private:
  DaqStateData _dsd;
  DvrDaq _dvrDaq;
};

#endif
