//
// $Id: DaqElogger.hh,v 1.1 2008/06/27 10:34:05 meyern Exp $
//

#ifndef DaqElogger_HH
#define DaqElogger_HH

#include <sstream>

// record/inc/daq
#include "DaqRunStart.hh"
#include "DaqRunType.hh"

#include "RcdUserRO.hh"


class DaqElogger : public RcdUserRO {
public:
  DaqElogger() :
    _runType(), _runNumber(0), _events(0) {
  }

  virtual ~DaqElogger() {
  }

  virtual bool record(RcdRecord &r) {
    if(doPrint(r.recordType())) {
      std::cout << "DaqElogger::record()" << std::endl;
      r.RcdHeader::print(std::cout," ") << std::endl;
    }

    // Check record type
    switch (r.recordType()) {

      // Run start 
    case RcdHeader::runStart: {
      // Access the DaqRunStart
      SubAccessor accessor(r);
      std::vector<const DaqRunStart*>
	v(accessor.extract<DaqRunStart>());
      assert(v.size()==1);

      _runType=v[0]->runType();
      _runNumber=v[0]->runNumber();

      if (_runType.writeRun()) {
	std::ostringstream command("elog_run.sh ", std::ios_base::ate);
	command << r.recordTypeName()
		<< " \"Start " << _runType.typeName()
		<< " run" << _runNumber << ". \"";

	FILE* pstream = popen(command.str().c_str(), "r");
	pclose(pstream);
      }
      break;
    }

      // Run end
    case RcdHeader::runEnd: {

      // Access the DaqRunEnd
      SubAccessor accessor(r);
      std::vector<const DaqRunEnd*>
	v(accessor.extract<DaqRunEnd>());
      assert(v.size()==1);

      _runType=v[0]->runType();
      _runNumber=v[0]->runNumber();
      _events=v[0]->actualNumberOfEventsInRun();

      if (_runType.writeRun()) {
	std::ostringstream command("elog_run.sh ", std::ios_base::ate);
	command << r.recordTypeName()
		<< " \"End " << _runType.typeName()
		<< " run" << _runNumber << ". "
		<< _events << " events\"";

	FILE* pstream = popen(command.str().c_str(), "r");
	pclose(pstream);
      }
      break;
    }

    default: {
      break;
    }
    };

    return true;
  }

protected:
  DaqRunType _runType;
  unsigned   _runNumber;
  unsigned   _events;

};

#endif // DaqElogger_HH
