//
// $Id: DhcSerialHeader.hh,v 1.1 2008/06/27 10:34:05 meyern Exp $
//

#ifndef DhcSerialHeader_HH
#define DhcSerialHeader_HH

#include "UtlPack.hh"

class DhcSerialHeader {

public:
 enum Register {
   REG_PLSR = 1,
   REG_IntD = 2,
   REG_Shp2D = 3,
   REG_Shp1D = 4,
   REG_BlrD = 5,
   REG_VtnD = 6,
   REG_VtpD = 7,
   REG_DCR = 8,
   REG_Inject = 9,
   REG_Kill = 11,
   REG_Wild = 21,
   REG_SCR = 27,
   REG_STR = 30,
   endOfRegisterEnum
 };

 enum Command {
   CMD_Write = 1,
   CMD_Set = 2,
   CMD_Read = 4,
   CMD_Reset = 5,
   CMD_Default = 6,
   endOfCommandEnum
 };

  DhcSerialHeader(Register r, Command c, char a, char d, char l)
  {  
    _data[0].bit(31, 1);
    reg(r);
    cmd(c);
    chip(a);
    dlink(d);
    len(l);
  }

  Register reg() const {
    return static_cast<Register>(_data[0].bits(19, 23));
  }

  void reg(Register r) {
    _data[0].bits(19, 23, r);
  }

  Command cmd() const {
    return static_cast<Command>(_data[0].bits(16, 18));
  }

  void cmd(Command c) {
    _data[0].bits(16, 18, c);
  }

  char chip() const {
    return _data[0].bits(24, 28);
  }

  void chip(char a) {
    _data[0].bits(24, 28, a);
  }

  unsigned dlink() const {
    return _data[2].byte(1);
  }

  void dlink(char d) {
    _data[2].byte(1, d);
  }

  unsigned len() const {
    return _data[2].byte(0);
  }

  void len(char l) {
    _data[2].byte(0, l);
  }

  bool valid() const {
    if (!_data[0].bit(31)) return false;
    if (chip() > 23 && chip() < 30) return false;
    if (reg() == REG_Inject || reg() == REG_Kill && len()<8) return false;
    return true;
  }


protected:
  UtlPack _data[3];

  static const std::string _registerName[endOfRegisterEnum];
  static const std::string _commandName[endOfCommandEnum];

};

const std::string DhcSerialHeader::_registerName[]={
  "null",
  "REG_PLSR",
  "REG_IntD",
  "REG_Shp2D",
  "REG_Shp1D",
  "REG_BlrD",
  "REG_VtnG",
  "REG_VtpD",
  "REG_DCR",
  "REG_Inject",
  "null",
  "REG_Kill",
  "null","null","null","null","null","null","null","null","null",
  "REG_Wild",
  "null","null","null","null","null",
  "REG_SCR",
  "null","null",
  "REG_STR"
};

const std::string DhcSerialHeader::_commandName[]={
  "null",
  "CMD_Write",
  "CMD_Set",
  "null",
  "CMD_Read",
  "CMD_Reset",
  "CMD_Default"
};

#endif // DhcSerialHeader_HH
