#ifndef DioBufferStatus_HH
#define DioBufferStatus_HH

#include <iostream>

#include "RcdTime.hh"

class DioBufferStatus {

public:
  RcdTime inputTime() const {
    return _inputTime;
  }

  void updateInputTime() {
    _inputTime.update();
  }

  RcdTime outputTime() const {
    return _outputTime;
  }

  void updateOutputTime() {
    _outputTime.update();
  }

  unsigned value() const {
    return _value;
  }

  void value(unsigned v) {
    _value=v;
    if(v>_maximum) _maximum=v;
  }

  void reset() {
    _maximum=0;
  }

  void print(ostream &o) {
    o << "DioBufferStatus::print()  "
      << "Last input time  = " << _inputTime << std::endl
      << "                          "
      << "Last output time = " << _outputTime << std::endl
      << "                          "
      << "Difference = " << 1000000.0*(_outputTime-_inputTime).deltaTime() 
      << " us" << std::endl
      << "                          "
      << "Number, maximum in buffer = " << _value
      << ", " << _maximum << std::endl;
  }

private:
  RcdTime _inputTime, _outputTime;
  unsigned _value,_maximum;
};

#endif
