#ifndef DioPair_HH
#define DioPair_HH

template<class Type> class DioProducer;
template<class Type> class DioConsumer;

template<class Type> class DioPair {

public:
  DioPair(DioProducer<Type> &p, DioConsumer<Type> &c)
    : _producer(p), _consumer(c) {
  }

  DioProducer<Type>& producer() const {
    return _producer;
  }

  DioConsumer<Type>& consumer() const {
    return _consumer;
  }

private:
  DioProducer<Type>& _producer;
  DioConsumer<Type>& _consumer;
};

#endif
