#ifndef DioSocketConsumer_HH
#define DioSocketConsumer_HH

#include "DuplexSocket.hh"
#include "DioConsumer.hh"


#ifdef DIO_SEND_OBJECTS

template<class Type> class DioSocketConsumer {

public:
  virtual ~DioSocketConsumer() {
  }

  virtual int push(const T&) = 0;

  /*
  virtual int llup(DioProducer<Type> &p) {
    return push(p.pull());
  }
  */

private:
};

#endif
#ifndef DIO_SEND_OBJECTS

template<class Type> class DioSocketConsumer
  : public DioConsumer<Type> {

public:
  DioSocketConsumer(int port, bool singleSocket=true) 
    : _duplexSocket(port,singleSocket) {
  }

  DioSocketConsumer(std::string host, int port, int tries = 0) 
    : _duplexSocket(host,port,tries) {
  }

  virtual ~DioSocketConsumer() {
  }

  virtual DioControl push(DioTypeHolder<Type>& h) {
    DioControl c(h.control());
    //cerr << "Sending Control" << endl;
    _duplexSocket.send(&c,1);
    //cerr << "Sending Type" << endl;
    _duplexSocket.send(h.pointer(),1);
    h.destroy();
    return h.control();
  }

private:
  DuplexSocket _duplexSocket;
  DioTypeHolder<Type> _holder;
};

#endif
#endif
