#ifndef DioThread_HH
#define DioThread_HH

#include <pthread.h>

#include "DioTypeHolder.hh"
#include "DioProducer.hh"
#include "DioConsumer.hh"


template<class Type> class DioThread {

public:
  DioThread(DioProducer<Type> &p, DioConsumer<Type> &c)
    : _producer(p), _consumer(c) {
  }

  int create() {
    std::cout << "DioThread::create() with ptr = " << this << std::endl;
    return pthread_create(&_pThread,0,thread,this);
  }

  int join() {
    std::cout << "DioThread::join()   with ptr = " << this << std::endl;
    return pthread_join(_pThread,0);
  }

  static void* thread(void *v) {
    std::cout << "DioThread::thread() with ptr = " << v << std::endl;

    DioThread<Type> *p(static_cast<DioThread<Type>*>(v));
    while(p->_producer.hsup(p->_consumer).status()==DioControl::ok);
    return 0;
  }

private:
  DioProducer<Type>& _producer;
  DioConsumer<Type>& _consumer;
  pthread_t _pThread;
};

#endif
