#ifndef DvrAhcNoise_HH
#define DvrAhcNoise_HH

#include <iostream>
#include <fstream>

// dual/inc/daq
#include "DaqRunStart.hh"
#include "DaqConfigurationStart.hh"
#include "DaqSpillStart.hh"

// dual/inc/rcd
#include "DvrCrcNoise.hh"
#include "AhcVfeConfigurationData.hh"

// dual/inc/sub
#include "SubInserter.hh"
#include "SubAccessor.hh"


class DvrAhcNoise : public DvrCrcNoise {

public:
  DvrAhcNoise(unsigned char c) : DvrCrcNoise(c) {
  }

  DvrAhcNoise(unsigned char c, unsigned p) : DvrCrcNoise(c,p) {
  }

  virtual ~DvrAhcNoise() {
  }

  bool record(RcdRecord &r) {

    assert(DvrCrcNoise::record(r));

    // Check record type
    switch (r.recordType()) {

    // Configuration start is used to set up system
    case RcdHeader::configurationStart: {

      SubInserter inserter(r);

      for(unsigned f(1);f<2;f++) {
	CrcLocationData<AhcVfeConfigurationData>
	  *d(inserter.insert< CrcLocationData<AhcVfeConfigurationData> >(true));
	d->crateNumber(_crateNumber);
	d->slotBroadcast(true);
	d->crcComponent((CrcLocation::CrcComponent)f);
	d->label(1);
      
	if(_printLevel>4) d->print(std::cout) << std::endl;
      }
      break;
    }

    default: {
      break;
    }
    };

    return true;
  }

  virtual bool feConfigurationData(RcdRecord &r) {
    SubInserter inserter(r);

    // FE                                                                                                                                     
    CrcLocationData<AhcFeConfigurationData>
      *d(inserter.insert< CrcLocationData<AhcFeConfigurationData> >(true));
    d->crateNumber(_crateNumber);
    d->slotBroadcast(true);
    d->crcComponent(CrcLocation::feBroadcast);
    d->label(1);

    unsigned nadc=18;
    d->data()->holdStart(1);
    d->data()->holdWidth(nadc*4*700);
    d->data()->vfeMplexClockPulses(nadc);

    AhcVfeControl c(0);
    //c.swHoldIn(true);
    //c.ledSel(true);
    d->data()->vfeControl(c);

    if(_printLevel>2) d->print(std::cout) << std::endl;

    return true;
  }

protected:
};

#endif
