#ifndef DvrEmcIntDac_HH
#define DvrEmcIntDac_HH

#include <iostream>
#include <fstream>

// dual/inc/daq
#include "DaqRunStart.hh"
#include "DaqConfigurationStart.hh"
#include "DaqSpillStart.hh"

// dual/inc/rcd
#include "RcdUserRW.hh"

// dual/inc/sub
#include "SubInserter.hh"
#include "SubAccessor.hh"


class DvrEmcIntDac : public RcdUserRW {

public:
  DvrEmcIntDac(unsigned char c) : RcdUserRW(), _crateNumber(c) {
  }

  DvrEmcIntDac(unsigned char c, unsigned p) : RcdUserRW(p), _crateNumber(c) {
  }

  virtual ~DvrEmcIntDac() {
  }

  /*
  void defaults() {
    // CrcReadoutConfigurationData
    _crcd.vmePeriod(0);
    _crcd.bePeriod(0);
    _crcd.fePeriod(0);
    _crcd.beSoftTrigger(true);
    
    _crcd.beTrgMode(1);
    _crcd.vlinkMode(3);

    // CrcLocationData<CrcBeConfigurationData>
    _cbcd.crateNumber(_crateNumber);
    _cbcd.slotBroadcast(true);
    _cbcd.crcComponent(CrcLocation::be);
    _cbcd.label(1);

    _cbcd.data()->mode(0x02);
    _cbcd.data()->test(0x00);
    _cbcd.data()->testLength(0);
    _cbcd.data()->trgEnables(0x1ff); // 0x1ff for J0
    //_cbcd.data()->trgEnables(0x2ff); // 0x2ff for internal

    // CrcLocationData<CrcBeTrgConfigurationData>
    _cbtcd.crateNumber(_crateNumber);
    _cbtcd.slotNumber(12);
    _cbtcd.crcComponent(CrcLocation::beTrg);
    _cbtcd.label(1);

    // CrcLocationData<EmcFeConfigurationData>
    _efcd.crateNumber(_crateNumber);
    _efcd.slotBroadcast(true);
    _efcd.crcComponent(CrcLocation::feBroadcast);
    _efcd.label(1);

    _efcd.data()->calibEnable(true);
    _efcd.data()->holdStart(30);

    unsigned nadc=18;
    _efcd.data()->holdWidth(nadc*4*700);
    _efcd.data()->vfeMplexClockPulses(nadc);
    _efcd.data()->frameSyncDelay(16);
    _efcd.data()->qdrDataDelay(3);
    
  }
  */

  bool record(RcdRecord &r) {

    // Check record type
    switch (r.recordType()) {


    // Run start 
    case RcdHeader::runStart: {

      // Access the DaqRunStart
      SubAccessor accessor(r);
      std::vector<const DaqRunStart*> v(accessor.extract<DaqRunStart>());
      assert(v.size()==1);

      DaqRunStart *w((DaqRunStart*)v[0]);
      w->runType(DaqRunStart::intDac);
      w->runSubtype(1);
      w->maximumNumberOfConfigurationsInRun(66);
      w->maximumNumberOfSpillsInRun(0xffffffff);
      w->maximumNumberOfEventsInRun(0xffffffff);

      if(_printLevel>0) {
        std::cout << "DvrEmcIntDac::record()  DaqRunStart subrecord"
                  << std::endl;
        v[0]->print(std::cout," ");
      }

      break;
    }


    // Configuration start is used to set up system
    case RcdHeader::configurationStart: {

      // Access the DaqConfigurationStart
      SubAccessor accessor(r);
      std::vector<const DaqConfigurationStart*> v(accessor.extract<DaqConfigurationStart>());
      assert(v.size()==1);

      DaqConfigurationStart *w((DaqConfigurationStart*)v[0]);
      w->maximumNumberOfSpillsInConfiguration(4);
      w->maximumNumberOfEventsInConfiguration(0xffffffff);

      if(_printLevel>2) {
        std::cout << "DvrEmcIntDac::record()  DaqConfigurationStart subrecord"
                  << std::endl;
        v[0]->print(std::cout," ");
      }

      const unsigned iConfiguration(v[0]->configurationNumberInRun());


      SubInserter inserter(r);

      // Add readout control
      CrcReadoutConfigurationData
	*b(inserter.insert<CrcReadoutConfigurationData>());
      *b=CrcReadoutConfigurationData();
      b->vmePeriod(1);
      b->bePeriod(1);
      b->beTrgPeriod(0);
      b->fePeriod(1);
      b->beTrgMode(0);
      b->vlinkMode(3);

      //b->clearBeTrgTrigger(true);
      //b->beTrgSoftTrigger(true);
      //b->beTrgPollNumber(1000);

      b->beSoftTrigger(true);
      //b->feBroadcastSoftTrigger(true);
      //b->feSoftTrigger(0,true);
      //b->feSoftTrigger(1,true);
      //b->feSoftTrigger(2,true);
      //b->feSoftTrigger(3,true);
      //b->feSoftTrigger(4,true);
      //b->feSoftTrigger(5,true);
      //b->feSoftTrigger(6,true);
      //b->feSoftTrigger(7,true);

      if(_printLevel>2) b->print(std::cout," ") << std::endl;
      

      if(b->clearBeTrgTrigger()) {
	b->beTrgPeriod(1);

            CrcLocationData<CrcBeTrgConfigurationData>
              *bt(inserter.insert< CrcLocationData<CrcBeTrgConfigurationData> >());
            bt->crateNumber(_crateNumber);
            bt->slotBroadcast(true);
            bt->crcComponent(CrcLocation::beTrg);
            bt->label(1);

            *bt->data()=CrcBeTrgConfigurationData();
            //
            //bt->data()->inputEnable(1<<0); // DevBoard
            bt->data()->inputEnable(1<<24); // Trg osc

            //bt->data()->outputEnable(1); // Bit 0 enables J0 fanout
            //bt->data()->oscillationPeriod(40000000); // 1 sec
            //bt->data()->oscillationPeriod(4000000); // 0.1 sec
            bt->data()->oscillationPeriod(400000); // 0.01 sec
            //bt->data()->oscillationPeriod(40000); // 0.001 sec
            bt->print(std::cout) << std::endl;
 
      }










      // BE
      CrcLocationData<CrcBeConfigurationData>
	*c(inserter.insert< CrcLocationData<CrcBeConfigurationData> >());
      c->crateNumber(_crateNumber);
      c->slotBroadcast(true);
      c->crcComponent(CrcLocation::be);
      c->label(1);
      
      *c->data()=CrcBeConfigurationData();
      c->data()->mode(0x02);
      c->data()->test(0x00);
      c->data()->testLength(0);
      c->data()->trgEnables(0x2ff); // 0x1ff for J0, 0x2ff for internal
      if(_printLevel>2) c->print(std::cout," ") << std::endl;

      // FE
      CrcLocationData<EmcFeConfigurationData>
	*d(inserter.insert< CrcLocationData<EmcFeConfigurationData> >());
      d->crateNumber(_crateNumber);
      d->slotBroadcast(true);
      d->crcComponent(CrcLocation::feBroadcast);
      d->label(1);
      
      *d->data()=EmcFeConfigurationData();
      unsigned nadc=18;
      d->data()->holdStart(1);
      d->data()->holdWidth(nadc*4*700);
      d->data()->vfeMplexClockPulses(nadc);


      unsigned dacBot(0),dacTop(0);
      d->data()->internalDacEnable(iConfiguration!=0 && iConfiguration!=65);

      if(d->data()->internalDacEnable()) {
	unsigned ic(iConfiguration-1);
	//if((ic%2)==0) dacBot=4096*(15-(ic/2)); // 32 configurations
        //else          dacTop=4096*(15-(ic/2));
	if((ic%2)==0) dacBot=2048*(31-(ic/2)); // 32 configurations
        else          dacTop=2048*(31-(ic/2));
      }

      d->data()->dacData(CrcFeConfigurationData::bot,dacBot);
      d->data()->dacData(CrcFeConfigurationData::top,dacTop);

      if(_printLevel>2) d->print(std::cout) << std::endl;

      break;
    }

    case RcdHeader::spillStart: {

      // Access the DaqSpillStart
      SubAccessor accessor(r);
      std::vector<const DaqSpillStart*> v(accessor.extract<DaqSpillStart>());
      assert(v.size()==1);

      DaqSpillStart *w((DaqSpillStart*)v[0]);
      w->maximumNumberOfEventsInSpill(256);

      if(_printLevel>4) {
        std::cout << "DvrEmcIntDac::record()  DaqSpillStart subrecord"
                  << std::endl;
        v[0]->print(std::cout," ");
      }

      break;
    }

    default: {
      break;
    }
    };

    return true;
  }


protected:
  unsigned char _crateNumber;
};

#endif
