#ifndef CommandServer_HH
#define CommandServer_HH

#include <cstdio>

#include "Command.hh"
#include "ShmSingleton.hh"

class CommandServer {


public:
  CommandServer() : _shmC(), _command(_shmC.payload()) {
  }

  const char* const send() {
    if(_command->runActive()) sprintf(r,"ACTIVE\n");
    else                      sprintf(r,"INACTIVE\n");
    std::cout << "Run Status " << r << std::endl;
    return r;
  }

  void recv(const char* const s) {
    unsigned t(0);

    switch(s[0]) {
    case 'r':
      //      std::cout << "Run command " << s[1]<< s[2] << s[3] << s[4] << std::endl;
      std::cout << "Run command " << s << std::endl;
      sscanf(s+1,"%u",&t);
      _command->runType(t);
      _command->command(Command::run);
      _command->print(cout);
      //      _command->runActive(true); /////////
      break;

    case 's':
      std::cout << "Stop command " << std::endl;
      _command->command(Command::stop);
      //      _command->runActive(false); /////////
      break;

    case 'k':
      std::cout << "Kill command " << std::endl;
      _command->command(Command::kill);
      break;

    default:
      std::cerr << "Unknown command " << s[0] << std::endl;
      break;
    };
  }

private:
  ShmSingleton<Command> _shmC;
  Command* const _command;
  char r[16];
};

#endif
