#ifndef OnlConfigurationType_HH
#define OnlConfigurationType_HH

#include <fstream>
#include <iostream>

#include "RcdArena.hh"
#include "OnlSubRecord.hh"
#include "OnlConfigurationStatus.hh"

class OnlConfigurationType {

public:
  OnlConfigurationType() : _arena() {
    reset(OnlRunStatus());
  }

  OnlConfigurationType(const OnlRunStatus &r) : _arena() {
    reset(r);
  }

  virtual ~OnlConfigurationType() {
  }

  const RcdArena& arena() const {
    return _arena;
  }

  RcdArena& arena() {
    return _arena;
  }

  /*
  OnlSpillStatus spillStatus() {
    OnlSubRecord<OnlConfigurationStatus> *sp(
    OnlSubRecord<OnlConfigurationStatus>::safeCast(_arena.firstSubHeader()));    
    OnlSpillStatus s(*(sp->payload()));
    s.maximumNumberOfEventsInSpill(_maximumNumberOfEventsInSpill);
    return s;
  }
  */

  void reset(const OnlRunStatus &r) {
    _arena.recordType(RcdHeader::startConfiguration);
    _arena.deleteSubHeaders();
    OnlConfigurationStatus c(r);
    OnlSubRecord<OnlConfigurationStatus> s;
    *(s.payload())=c;
    _arena.appendSubHeader(&s);
    _maximumNumberOfEventsInSpill=0;
  }

  unsigned maximumNumberOfEventsInSpill() const {
    return _maximumNumberOfEventsInSpill;
  }

  void maximumNumberOfEventsInSpill(unsigned m) {
     _maximumNumberOfEventsInSpill=m;
  }

  bool read(unsigned n, unsigned t) {
    char file[128];
    sprintf(file,"/usr/users/calice/daq/daq/typ/ctp%06.6u.asc",t);
    std::string s(file);
    cout << s << endl;
    return read(s,n,t);
  }

  bool read(const std::string &filename, unsigned n, unsigned t) {
    std::ifstream i(filename.c_str(),ios::in);
    if(!i) return false;

    OnlSubRecord<OnlConfigurationStatus> *sp(
    OnlSubRecord<OnlConfigurationStatus>::safeCast(_arena.firstSubHeader()));
    if(sp==0) return false;
    OnlConfigurationStatus *r(sp->payload());
    if(r==0) return false;
    
    unsigned maxS(0),maxE(0);
    i >> maxS >> maxE >> _maximumNumberOfEventsInSpill;

    r->configurationNumberInRun(n);
    r->configurationType(t);
    r->maximumNumberOfSpillsInConfiguration(maxS);
    r->maximumNumberOfEventsInConfiguration(maxE);

    RcdSubHeader *h(_arena.lastSubHeader());

    unsigned type(0),bytes(0);
    i >> type >> bytes;
    cout << type  << " " << bytes << std::endl;

    while(!i.eof()) {
      h->subRecordType(type);
      h->numberOfBytes(bytes);
      unsigned *p((unsigned*)(h+1));
      
      for(unsigned j(0);j<(bytes+3)/4;j++) {
	i >> p[j];
      }

      h=h->nextSubHeader();
      i >> type >> bytes;
      cout << type  << " " << bytes << std::endl;
    }

    *h=RcdSubHeader(0,0);
    _arena.print(std::cout);
    return true;
  }

  bool write(unsigned t) {
    char file[128];
    sprintf(file,"/usr/users/calice/daq/daq/typ/ctp%06.6u.asc",t);
    std::string s(file);
    cout << s << endl;
    return write(s);
  }

  bool write(const std::string &filename) {
    std::ofstream o(filename.c_str(),ios::out);
    if(!o) return false;
    
    OnlSubRecord<OnlConfigurationStatus> 
      *sp(OnlSubRecord<OnlConfigurationStatus>::safeCast(_arena.firstSubHeader()));
    if(sp==0) return false;
    OnlConfigurationStatus *r(sp->payload());
    if(r==0) return false;
    
    o << r->maximumNumberOfSpillsInConfiguration()
      << r->maximumNumberOfEventsInConfiguration()
      << _maximumNumberOfEventsInSpill << std::endl;

    for(RcdSubHeader *h(_arena.firstSubHeader());h!=0;h=h->nextSubHeader()) {
        o << h->subRecordType() << h->numberOfBytes();
        unsigned *p((unsigned*)(h+1));
        for(unsigned j(0);j<(h->numberOfBytes()+3)/4;j++) {
	  o << p[j];
        }
        o << std::endl;
    }
  }


private:
  RcdArena _arena;
  unsigned _maximumNumberOfEventsInSpill;
};

#endif
