#ifndef OnlDriver_HH
#define OnlDriver_HH

#include <sys/types.h>

#include <iostream>
#include <fstream>
#include <ctime>

#include "RcdArena.hh"
//include "BufferStatus.hh"
#include "VmeInterrupt.hh"
//include "TrgConfigurationSubRecord.hh"
#include "ShmSingleton.hh"
#include "OnlEventStatus.hh"
#include "OnlRunType.hh"
#include "OnlCommandSocket.hh"

#include "RcdArena.hh"

class OnlDriver : public DioProducer<RcdArena> {

public:
  OnlDriver() : 		   _shmI(), _vmeInterrupt(_shmI.payload()),
		   _startUp(true), _state(OnlRunStatus::inactive),
		_commandSocket(12345) {

    if(!_vmeInterrupt->setConsumerPid()) {
      cerr << " Cannot register with ShmSingleton<VmeInterrupt>" 
	   << flush << endl;      
    }

    _runNumber=readRunNumber();
    cout << " Next run number " << _runNumber << endl;

    _status.print(std::cout);


    // Set initial state to inactive

    sendState();
  }

  virtual ~OnlDriver() {
  }

  void recv(bool err) const {
    if(_resetTrigger) {
      _vmeInterrupt->trigger(false);
      _vmeInterrupt->signalProducer();
    }
  }

  virtual DioConsumer<OnlRunStatus::RunState>& commandConsumer() {
    return _commandSocket;
  }

  virtual DioProducer<OnlCommand>& commandProducer() {
    return _commandSocket;
  }

  DioTypeHolder<RcdArena>& pull() {

    // Make the arena which will be returned

    _holder.create();
    RcdRecord *record(_holder.pointer());
    _holder.control(DioControl(DioControl::ok));


    _resetTrigger=false;
    //    TrgConfigurationSubRecord *tcsr;

    bool invalidCommand(true);

    switch(_state) {

    case OnlRunStatus::inactive:

      // Go to running if tcl command
      //
      // Go through shutdown if tcl command
      
      while(invalidCommand) {
	_commandHolder=_commandSocket.pull();

	if(_commandHolder.pointer()->command()==RcdHeader::startRun) {
	  invalidCommand=false;

	  _runType.reset(_runNumber);
	  
	  _runNumber++;
	  if(!writeRunNumber(_runNumber)){
	    std::cerr << "OnlDriver::pull()  Run number write to file failed" 
		 << std::endl;
	  } else {
	    std::cout << "OnlDriver::pull()  Next run number written to file "
		      << std::flush;
	    system("cat etc/runnumber.dat");
	  }
	  
	  if(_commandHolder.pointer()->data()==999999) {
	    _manual=true;
	  } else {
	    _runType.read(_commandHolder.pointer()->data());
	  }
	  
	  /*
	    if(_record.recordType()!=RecordHeader::startOfRun) {
	    cerr << " Record type from file = " << _record.recordType()
	    << " does not match startOfRun = " << RecordHeader::startOfRun << endl;
	    }
	    
	    if(_command->runType()!=0 && _command->runType()!=_record.runType()) {
	    cerr << " Run type from file = " << _record.runType()
	    << " does not match requested type = " << _command->runType() << endl;
	    }
	  */
	  
	  
	  *record=_runType.arena();
	  //	  _status=_runType.status();
	  _state=OnlRunStatus::running;
	}
	
	
	if(_commandHolder.pointer()->command()==RcdHeader::shutdown) {
	  invalidCommand=false;
	  record->recordType(RcdHeader::shutdown);
	  _holder.control(DioControl(DioControl::shutdown));
	}	
	
	_commandSocket.pop();
      }
      break;

    case OnlRunStatus::running:

      // Go to inactive if
      // Manual - driven by tcl command
      // Auto - finished all configurations
      //
      // Go to triggerableOutOfSpill if
      // Manual - driven by tcl command
      // Auto - if not finished all configurations

      if(_manual) {
	while(invalidCommand) {
	  _commandHolder=_commandSocket.pull();

	  if(_commandHolder.pointer()->command()==RcdHeader::startConfiguration) {
	    invalidCommand=false;
	    OnlConfigurationType _configurationType;
	    _configurationType.read(_runNumber,_commandHolder.pointer()->data());

	    *record=_configurationType.arena();
	    _state=OnlRunStatus::triggerableOutOfSpill;
	  }

	  if(_commandHolder.pointer()->command()==RcdHeader::stopRun) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::stopRun);
	    _status.stopRun();
	    OnlSubRecord<OnlRunStatus> r;
	    r.payload(&_status);
	    record->appendSubHeader(&r);
	    _state=OnlRunStatus::inactive;
	  }

	  _commandSocket.pop();
	}
      }
      /*

      } else {
	if(_status.complete(_state)) {
	}

      if(_configurationNumberInRun>=_numberOfConfigurationsInRun) {


	makeEndOfRunRecord();
	_record.print(cout);
      
	_state=0;
	
	_command->command(Command::null);
	_command->runActive(false);
	return &_record;
      }


      _record.print(cout);
	
      if(_record.recordType()!=RecordHeader::startOfConfiguration) {
	cerr << " Record type from file = " << _record.recordType()
	     << " does not match startOfConfiguration = " << RecordHeader::startOfConfiguration << endl;
      }
      if(_record.configurationNumber()!=_configurationNumberInRun) {
	cerr << " Configuration number from file = " << _record.configurationNumber()
	     << " does not match number seen = " << _configurationNumberInRun << endl;
      }
      
      _configurationType=_record.configurationType();
      _numberOfEventsInConfiguration=_record.numberOfEventsInConfiguration();
      _spillNumberInConfiguration=0;
      _eventNumberInConfiguration=0;
      _numberOfEventsInSpill=0xffffffff; // TO BE FILLED FROM ?
      _eventNumberInSpill=0; // MAY NOT BE START OF SPILL IMMEDIATELY
      
      makeStartOfConfigurationRecord();
      _record.print(cout);
	
      tcsr=(TrgConfigurationSubRecord*)_record.getSubRecord(SubRecord::trigger);
      _selfTrigger=false;
      if(tcsr!=0) {
	_selfTrigger=tcsr->ignorTrigger();
      }
      if(_selfTrigger) cout << "Trigger being ignored" << endl;
      else              cout << "Trigger being looked at" << endl;
      
      _vmeInterrupt->trigger(false);
      
      _state=2;
      _command->command(Command::null);
      _command->runActive(true);
      return &_record;
      */

      break;
    
    case OnlRunStatus::triggerableOutOfSpill:

      // Go to running if
      // Manual - driven by tcl command
      // Auto - if finished all spills
      //
      // Go to paused if driven by tcl command
      //
      // Go to spill if
      // Manual - driven by tcl command
      // Auto - if not finished all spills and not self-trigger
      //        and startSpill occurs
      //
      // Go through event if
      // Manual - driven by tcl command
      // Auto - if not finished all events and self-trigger

      if(_manual) {
	while(invalidCommand) {
	  _commandHolder=_commandSocket.pull();

	  if(_commandHolder.pointer()->command()==RcdHeader::stopConfiguration) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::stopConfiguration);
	    _status.stopConfiguration();
	    OnlSubRecord<OnlConfigurationStatus> r;
	    r.payload(&_status);
	    record->appendSubHeader(&r);
	    _state=OnlRunStatus::running;
	  }

	  if(_commandHolder.pointer()->command()==RcdHeader::pause) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::pause);
	    _state=OnlRunStatus::paused;
	  }
	  
	  if(_commandHolder.pointer()->command()==RcdHeader::startSpill) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::startSpill);
	    OnlSpillStatus s;
	    OnlSubRecord<OnlSpillStatus> r;
	    r.payload(&s);
	    record->appendSubHeader(&r);
	    _state=OnlRunStatus::spill;
	  }	
	  
	  if(_commandHolder.pointer()->command()==RcdHeader::event) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::event);
	    OnlEventStatus s;
	    OnlSubRecord<OnlEventStatus> r;
	    r.payload(&s);
	    record->appendSubHeader(&r);
	    _state=OnlRunStatus::triggerableOutOfSpill;
	  }
	  
	  _commandSocket.pop();
	}
      }

      /*
      while(true) {
	if(_eventNumberInConfiguration>=_numberOfEventsInConfiguration) {

	  makeEndOfConfigurationRecord();
	  _record.print(cout);
	  
	  _state=1;
	  _command->command(Command::null);
	  _command->runActive(true);
	  return &_record;
	}

	if(_command->command()==Command::stop) {

	  makeStopConfigurationRecord();
	  _record.print(cout);
	  
	  _state=1;
	  _command->command(Command::null);
	  _command->runActive(true);
	  return &_record;
	}

	if(_selfTrigger) {
	  makeEventRecord();
	  //_record.print(cout);
	  
	  //	  _resetTrigger=true;
	  _command->runActive(true);
	  return &_record;
	}

	if(_vmeInterrupt->spill()) {
	  _eventNumberInSpill=0;

	  makeStartOfSpillRecord();
	  _record.print(cout);

	  _state=3;
	  _command->runActive(true);
	  return &_record;
	}

	if(_vmeInterrupt->trigger()) {
	  makeEventRecord();
	  //_record.print(cout);

	  _resetTrigger=true;
	  _command->runActive(true);
	  return &_record;

	} else {
	  _vmeInterrupt->enableConsumerSignal();
	  sleep(1);
	  _vmeInterrupt->disableConsumerSignal();
	}
      }
      */
      break;

    case OnlRunStatus::spill:

      // Go to triggerableOutOfSpill if
      // Manual - driven by tcl command
      // Auto - if finished all events or if endSpill occurs
      //
      // Go through event if
      // Manual - driven by tcl command
      // Auto - if not finished all events and event occurs
      //
      // Should not be here if self-trigger

      if(_manual) {
	while(invalidCommand) {
	  _commandHolder=_commandSocket.pull();

	  if(_commandHolder.pointer()->command()==RcdHeader::stopSpill) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::stopSpill);
	    OnlSpillStatus s;
	    OnlSubRecord<OnlSpillStatus> r;
	    r.payload(&s);
	    record->appendSubHeader(&r);
	    _state=OnlRunStatus::triggerableOutOfSpill;
	  }
	  
	  if(_commandHolder.pointer()->command()==RcdHeader::event) {
	    invalidCommand=false;
	    record->recordType(RcdHeader::event);
	    OnlEventStatus s;
	    OnlSubRecord<OnlEventStatus> r;
	    r.payload(&s);
	    record->appendSubHeader(&r);
	    _state=OnlRunStatus::spill;
	  }
	  
	  _commandSocket.pop();
	}
      }

      /*
      while(true) {
	if(_eventNumberInConfiguration>=_numberOfEventsInConfiguration ||
	   _eventNumberInSpill>=_numberOfEventsInSpill) {

	  makeEndOfSpillRecord();
	  _record.print(cout);

	  _state=2;
	  _command->runActive(true);
	  return &_record;
	}

	if(_command->command()==Command::stop) {

	  makeStopSpillRecord();
	  _record.print(cout);

	  _state=2;
	  //_command->command(Command::null); ?? NO! FORCE DOWN TO LEVEL 1
	  _command->runActive(true);
	  return &_record;
	}

	if(_selfTrigger) {
	  makeEventRecord();
	  //_record.print(cout);
	  
	  //	  _resetTrigger=true;
	  _command->runActive(true);
	  return &_record;
	}

	if(!_vmeInterrupt->spill()) {
	  makeEndOfSpillRecord();
	  _record.print(cout);

	  _state=2;
	  _command->runActive(true);
	  return &_record;
	}

	if(_vmeInterrupt->trigger()) {
	  makeEventRecord();
	  //_record.print(cout);
	  
	  _resetTrigger=true;
	  _command->runActive(true);
	  return &_record;

	} else {
	  _vmeInterrupt->enableConsumerSignal();
	  sleep(1);
	  _vmeInterrupt->disableConsumerSignal();
	}
      }

      */
      break;

    case OnlRunStatus::paused:

      // Go to triggerableOutOfSpill if driven by tcl command

      while(invalidCommand) {
	_commandHolder=_commandSocket.pull();

	if(_commandHolder.pointer()->command()==RcdHeader::resume) {
	  invalidCommand=false;
	  record->recordType(RcdHeader::resume);
	  _state=OnlRunStatus::triggerableOutOfSpill;
	}
	
	_commandSocket.pop();
      }
      break;


    default:
      _state=OnlRunStatus::inactive;
      break;
    };


    sendState();
    record->updateRecordTime();
    std::cout << "OnlDriver::pull() sending record at " << record << std::endl;
    record->print(std::cout);
    return _holder;
  }

  /*
  void makeStartUpRecord() {
    _record.recordType(RecordHeader::startUp);
    _record.recordTime(time(0));
    _record.recordNumber(0);
    _record.zeroOthers();
    _record.deleteSubRecords();
  }

  void makeStartOfRunRecord() {
    _record.recordType(RecordHeader::startOfRun);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.runNumber(_runNumber);
    _record.runType(_runType);
    _record.numberOfConfigurations(_numberOfConfigurationsInRun);
  }

  void makeStartOfConfigurationRecord() {
    _record.recordType(RecordHeader::startOfConfiguration);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);	
    _record.configurationNumber(_configurationNumberInRun);
    _record.configurationType(_configurationType);
    _record.numberOfEventsInConfiguration(_numberOfEventsInConfiguration);
  }

  void makeStartOfSpillRecord() {
    _record.recordType(RecordHeader::startOfSpill);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.spillNumber(_spillNumberInRun);
    _record.spillNumberInConfiguration(_spillNumberInConfiguration);
    _record.numberOfEventsInSpill(_numberOfEventsInSpill);
    _record.deleteSubRecords();
  }

  void makeEventRecord() {
    _record.recordType(RecordHeader::event);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.eventNumber(_eventNumberInRun++);
    _record.eventNumberInConfiguration(_eventNumberInConfiguration++);
    _record.eventNumberInSpill(_eventNumberInSpill++);
    _record.deleteSubRecords();
  }

  void makeStopSpillRecord() {
    _record.recordType(RecordHeader::stopSpill);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.spillNumber(_spillNumberInRun++);
    _record.spillNumberInConfiguration(_spillNumberInConfiguration++);
    _record.numberOfEventsInSpill(_eventNumberInSpill);
    _record.deleteSubRecords();
  }

  void makeEndOfSpillRecord() {
    _record.recordType(RecordHeader::endOfSpill);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.spillNumber(_spillNumberInRun++);
    _record.spillNumberInConfiguration(_spillNumberInConfiguration++);
    _record.numberOfEventsInSpill(_eventNumberInSpill);
    _record.deleteSubRecords();
  }

  void makeStopConfigurationRecord() {
    _record.recordType(RecordHeader::stopConfiguration);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.configurationNumber(_configurationNumberInRun++);
    _record.configurationType(_configurationType);
    _record.numberOfEventsInConfiguration(_eventNumberInConfiguration);
    _record.deleteSubRecords();
  }

  void makeEndOfConfigurationRecord() {
    _record.recordType(RecordHeader::endOfConfiguration);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.configurationNumber(_configurationNumberInRun++);
    _record.configurationType(_configurationType);
    _record.numberOfEventsInConfiguration(_eventNumberInConfiguration);
    _record.deleteSubRecords();
  }

  void makeEndOfRunRecord() {
    _record.recordType(RecordHeader::endOfRun);
    _record.recordTime(time(0));
    _record.recordNumber(_recordNumberInRun++);
    _record.runNumber(_runNumber++);
    _record.runType(_runType);
    _record.numberOfConfigurations(_configurationNumberInRun);
    _record.deleteSubRecords();
  }

  void makeShutdownRecord() {
    _record.recordType(RecordHeader::shutdown);
    _record.recordTime(time(0));
    _record.recordNumber(0);
    _record.zeroOthers();
    _record.deleteSubRecords();
  }
  */

private:
  unsigned readRunNumber() {
    ifstream fin("etc/runnumber.dat",ios::in);
    if(!fin) return 0;
    unsigned n(0);
    fin >> n;
    return n;
  }

  bool writeRunNumber(unsigned n) {
    ofstream fout("etc/runnumber.dat",ios::out);
    if(!fout) return false;
    fout << n << endl;
    return true;
  }

  void sendState() {
    OnlRunStatus::RunState *s(new OnlRunStatus::RunState(_state));
    DioTypeHolder<OnlRunStatus::RunState> h(s,DioControl(DioControl::ok));
    _commandSocket.push(h);
    _commandSocket.poc();
  }

  ShmSingleton<VmeInterrupt> _shmI;
  VmeInterrupt *_vmeInterrupt;
  bool _startUp;

  OnlRunStatus::RunState _state;
  bool _resetTrigger,_selfTrigger;

  unsigned _runNumber;

  bool _manual;
  OnlEventStatus _status;
  DioTypeHolder<RcdArena> _holder;

  OnlRunType _runType;

  OnlCommandSocket _commandSocket;
  DioTypeHolder<OnlCommand> _commandHolder;
  DioTypeHolder<OnlRunStatus::RunState> _stateHolder;
};

#endif
