#ifndef OnlSamplerStatus_HH
#define OnlSamplerStatus_HH

class OnlSamplerStatus {

public:
  void startRun() {
    _totalR=0;
    _removedR=0;
  }

  void startConfiguration() {
    _totalC=0;
    _removedC=0;
  }

  void startSpill() {
    _totalS=0;
    _removedS=0;
  }

  void event(bool remove=false) {
    _totalR++;
    _totalC++;
    _totalS++;
    if(remove) {
      _removedR++;
      _removedC++;
      _removedS++;
    }
  }

  void print(ostream &o) {
    o << "OnlSamplerStatus::print()  "
      << "Total number of events per run, configuration, spill "
      << _totalR << ", " << _totalC << ", " << _totalS << std::endl
      << "                           "
      << "Removed number of events per run, configuration, spill "
      << _removedR << ", " << _removedC << ", " << _removedS << std::endl
      << "                           "
      << "Fractions removed per run, configuration, spill "
      << double(_removedR)/_totalR << ", "
      << double(_removedC)/_totalC << ", "
      << double(_removedS)/_totalS << std::endl;
  }

private:
  unsigned _totalR,_totalC,_totalS;
  unsigned _removedR,_removedC,_removedS;
};

#endif
