#ifndef OnlSocketConsumer_HH
#define OnlSocketConsumer_HH

#include "DuplexSocket.hh"
#include "RcdTime.hh"
#include "RcdArena.hh"
#include "SubRecord.hh"
#include "DaqSubRecordId.hh"
#include "DioConsumer.hh"


#ifndef DIO_SEND_OBJECTS

class OnlSocketConsumer : public DioConsumer<RcdArena> {

public:
  OnlSocketConsumer(int port, bool singleSocket=true) 
    : _duplexSocket(port,singleSocket) {
  }

  OnlSocketConsumer(std::string host, int port, int tries = 0) 
    : _duplexSocket(host,port,tries) {
  }

  virtual ~OnlSocketConsumer() {
  }

  virtual DioControl push(DioTypeHolder<RcdArena>& h) {
    _time.update();

    DioControl c(h.control());
    //cerr << "OnlSocketConsumer::push() Sending Control" << endl;
    _duplexSocket.send(&c,1);

    RcdArena *a(h.pointer());
    SubRecord<RcdTime>::safePayloadAppend(a,&_time);

    //cerr << "OnlSocketConsumer::push() Sending length" << endl;
    unsigned n(a->totalNumberOfBytes());
    _duplexSocket.send(&n,1);

    //cerr << "OnlSocketConsumer::push() Sending record" << endl;
    //_duplexSocket.send(h.pointer(),1);
    _duplexSocket.send((const char*)a,n);

    //_duplexSocket.printSendInfo(std::cout);

    h.destroy();
    return h.control();
  }

private:
  DuplexSocket _duplexSocket;
  DioTypeHolder<RcdArena> _holder;
  RcdTime _time;
};

#endif
#endif
