#ifndef OnlWriterAsc_HH
#define OnlWriterAsc_HH

#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "OnlWriter.hh"

class OnlWriterAsc : public OnlWriter {

public:
  OnlWriterAsc() : pout(0) {
  }

  virtual ~OnlWriterAsc() {
    delete pout;
  }

  bool open(unsigned n) {
    char file[128];
    sprintf(file,"dat/run%06.6u.asc",n);
    pout=new ofstream(file,ios::out);
	
    if(pout==0 || !(*pout)) {
      cerr << " Error opening file " << file << endl;
      _error=true;
      
    } else {
      cout << " New run: number " << n
	   << " writing to file " << file << endl;
      _error=false;
    }
    return _error;
  }

  bool write(const RcdRecord *r) {
    return r->write(*pout);
  }

  bool close() {
    delete pout;
    pout=0;
    return true;
  }


private:
  ofstream *pout;
};

#endif
