#ifndef OnlWriterBin_HH
#define OnlWriterBin_HH

#include <iostream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "OnlWriter.hh"

class OnlWriterBin : public OnlWriter {

public:
  OnlWriterBin() : _fileDescriptor(-1) {
  }

  bool open(unsigned n) {
    char file[128];
    sprintf(file,"dat/run%06.6u.bin",n);
    _fileDescriptor=creat(file,S_IRUSR|S_IRGRP|S_IROTH);
	
    if(_fileDescriptor<0) {
      std::cerr << " Error opening file " << file << endl;
      _error=true;
      
    } else {
      std::cout << " New run: number " << n
		<< " writing to file " << file << endl;
      _error=false;
    }
    return _error;
  }

  bool write(const RcdRecord *r) {
    unsigned n(r->totalNumberOfBytes());
    if(write(_fileDescriptor,r,n)!=n) {
      std::cerr << " Error writing to file; number of bytes written < "
	   << n << std::endl;
      return false;
    }
    return true;
  }

  bool close() {
    close(_fileDescriptor);
  }


private:
  int _fileDescriptor;
};

#endif
