#ifndef WriterServer_HH
#define WriterServer_HH

#include "BufferStatus.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"

class WriterServer {


public:
  WriterServer(bool dummy=false) : _shmR(), _recordBuffer(_shmR.payload()) {
    if(_recordBuffer!=0) {
      if(!_recordBuffer->setConsumerPid(dummy)) _recordBuffer=0;
    }
    if(_recordBuffer==0) cerr << "recordBuffer zero" << flush << endl;
  }

  ~WriterServer() {
    if(_recordBuffer==0) return;
    if(!_recordBuffer->dummyConsumerPid()) _recordBuffer->zeroConsumerPid();
  }

  Record* send() {
    if(_recordBuffer==0) return 0;
    Record *r(_recordBuffer->getOldEvent());
    if(r->recordType()!=RecordHeader::event) r->print(cout);
    return r;
  }

  void recv(bool error) const {
    if(_recordBuffer==0) return;
    _recordBuffer->releaseOldEvent();
  }

private:
  ShmSingleton<RecordBuffer> _shmR;
  RecordBuffer* _recordBuffer;
};

#endif
