#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "HardwareAccessException.hh"

#include "UtlArguments.hh"
#include "DaqBusAdapter.hh"
#include "CrcVmeDevice.hh"

using namespace std;

int main(int argc, const char **argv) {

  UtlArguments argh(argc,argv);
  const bool printExceptions(argh.option('e',false,"Print exception errors"));
  if(argh.help()) return 0;

  HAL::VMEAddressTableASCIIReader addressTableReader("online/hal/CrcVmeAddress.hal");
  HAL::VMEAddressTable addressTable("CRC VME Address Table",addressTableReader);

  for(unsigned p(0);p<2;p++) {
    try{
      DaqBusAdapter busAdapter(p);
      cout << "PCI card " << p << " is alive" << endl;
      
      for(unsigned i(5);i<22;i++) {
	CrcVmeDevice dev(addressTable,busAdapter,i);
	if(dev.alive()) cout << "  CRC at slot "
			     << setw(2) << i << " is alive" << endl;
      }


    } catch ( HAL::HardwareAccessException& e ) {
      if(printExceptions) cout << "*** HardwareAccessException occurred : " << e.what() << endl;
      
    } catch ( exception e ) {
      if(printExceptions) cout << "*** Unknown exception occurred" << endl;
    }
  }
}
