#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CercVmeSerialCommandBits.hh"
#include "CercVmeDevice.hh"
#include "CercFeConfigurationData.hh"
#include "SlwCercReadout.hh"
#include "RcdArena.hh"
#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdWriterAsc.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"

bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);


  unsigned numberOfCercs(1);
  unsigned *addressOfCerc(new unsigned[numberOfCercs]);
  addressOfCerc[0]=7;

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCercs << endl;
    CercVmeDevice *CercVMECard[20];
    for(unsigned i(0);i<numberOfCercs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCerc[i] << dec << endl;
      CercVMECard[i]=new CercVmeDevice(addressTable,busAdapter,addressOfCerc[i]);
    }

    //CercVmeDevice CercVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    string item, name;
    unsigned long nCard;
    vector<string> names;

    nCard=0;

    unsigned t;
    std::string w;

    cout << "Target: ";
    if(argh.isArgument(0)) {
      t=argh.argument(0,1);
      cout << t << endl;
    } else {
      cin >> t;
    }

    CercVmeSerialCommandBits<10> add((CercVmeSerialHeader::Target)t,CercSerialHeader::designator08);
    CercVmeSerialCommandBits<16> wdt((CercVmeSerialHeader::Target)t,CercSerialHeader::designator07);
    CercVmeSerialCommandBits<16> rdt((CercVmeSerialHeader::Target)t,CercSerialHeader::designator29);


    unsigned short wArray[4][1024],rArray[4][1024];

    for(unsigned j(0);j<4;j++) {
      cout << endl << endl << "Doing loop of ";
      if(j==0) cout << "zeros";
      if(j==1) cout << "ones";
      if(j==2) cout << "counts";
      if(j==3) cout << "tilde-counts";
      cout << endl << endl;

      for(unsigned i(0);i<1024;i++) {
	cout << endl << "Writing j = " << j << " i = " << i << endl;

	if(j==0) wArray[j][i]=0;
	if(j==1) wArray[j][i]=0x7fff;
	if(j==2) wArray[j][i]=i;
	if(j==3) wArray[j][i]=(~i)&0x7fff;
	
	if(i== 1) wArray[j][i]&=0x0001;
	if(i== 6) wArray[j][i]&=0x0001;
	if(i==23) wArray[j][i]&=0x00ff;
	if(i==30) wArray[j][i]&=0x000f;

	add.bits(i);
	CercVMECard[nCard]->serialWrite(&add);
	wdt.bits(wArray[j][i]);
	CercVMECard[nCard]->serialWrite(&wdt);
      }

      for(unsigned i(0);i<1024;i++) {
	if(
(i==2) || (i==3) || (i==7) || (i==8) || (i==9) || (i==10) || (i==11) ||
(i==14) || (i==15) || (i==18) || (i==19) || (i==25) || (i==26) || (i==27)
	   || ((i>34) && (i<512))) {
	  rArray[j][i]=wArray[j][i];
	} else {
	  cout << endl << "Reading j = " << j << " i = " << i << endl;

	  add.bits(i);
	  CercVMECard[nCard]->serialWrite(&add);
	  CercVMECard[nCard]->serialRead(&rdt);
	  rArray[j][i]=rdt.bits();
	}
      }
    }

    for(unsigned j(0);j<4;j++) {
      for(unsigned i(0);i<1024;i++) {
	if(wArray[j][i]!=rArray[j][i]) {
	  cout << "ERROR j " << j << " i " << i << hex
	       << " wArray = " << wArray[j][i] 
	       << " rArray = " << rArray[j][i] << dec << endl;
	}
      }
    }


  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << "I Made This" << endl;

  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  return 0;
}
