#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "RcdWriterAsc.hh"
#include "RcdWriterBin.hh"
#include "RcdWriterDmy.hh"
#include "DaqRunStart.hh"

#include "SubAccessor.hh"

#include "CrcLocationData.hh"
#include "EmcReadout.hh"
#include "CrcReadoutConfigurationData.hh"
#include "OnlCounter.hh"
#include "HstNoise.hh"
#include "HstChipNoise.hh"
#include "HstChanNoise.hh"
#include "ChkPrint.hh"

#include "BmlLc1176VmeDevice.hh"
#include "BmlLc1176Readout.hh"

#include "DvrEmcVfeDac.hh"

#include "OnlRunNumber.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "online/hal/CrcVmeAddress.hal"
#define TDCVMEADDRESSTABLE "online/hal/Lc1176VmeAddress.hal"
#define SEQUENCE_SETTINGS "Sequences.dat"


bool continueJob=true;
bool continueRun=true;
bool continueConfiguration=true;
bool continueSpill=true;

void signalHandler(int signal) {
  std::cerr << "Process " << getpid() << " received signal "
	    << signal << std::endl;
  continueJob=false;
}

int main(int argc, const char **argv) {
  DvrEmcVfeDac dvr;
  dvr.printLevel(10);
  ChkPrint print;
  
  RcdArena arena;
  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::runStart);
  dvr.record(arena);
  print.record(arena);
  
  SubAccessor extracter(arena);
  std::vector<const DaqRunStart*> vr(extracter.extract<DaqRunStart>());
  assert(vr.size()==1);

  const unsigned nConfiguration(vr[0]->maximumNumberOfConfigurationsInRun());
  for(unsigned iConfiguration(0);iConfiguration<nConfiguration;iConfiguration++) {
    arena.deleteData();
    arena.updateRecordTime();
    arena.recordType(RcdHeader::configurationStart);
    dvr.record(arena);
    print.record(arena);

    SubAccessor extracter(arena);
    std::vector<const DaqConfigurationStart*> vc(extracter.extract<DaqConfigurationStart>());
    assert(vc.size()==1);

    const unsigned nSpill(vc[0]->maximumNumberOfSpillsInConfiguration());
    for(unsigned iSpill(0);iSpill<nSpill;iSpill++) {
      arena.deleteData();
      arena.updateRecordTime();
      arena.recordType(RcdHeader::spillStart);
      dvr.record(arena);
      print.record(arena);

      arena.deleteData();
      arena.updateRecordTime();
      arena.recordType(RcdHeader::spillEnd);
      dvr.record(arena);
      print.record(arena);
    }

    arena.deleteData();
    arena.updateRecordTime();
    arena.recordType(RcdHeader::configurationEnd);
    dvr.record(arena);
    print.record(arena);
  }

  return 0;
}
