// g++ -Wall -I ../../daq/dual/inc/utl -I ../../daq/dual/inc/daq -I ../../daq/dual/inc/rcd -I ../../daq/dual/inc/emc -I ../../daq/dual/inc/sub -I ../inc/msg -I ../inc/usb -I ../inc/hod -I ../inc/cec -I ../inc/rcd noise.cc -o noise.exe

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "UtlTime.hh"
#include "UtlArguments.hh"

#include "RcdArena.hh"
#include "SubAccessor.hh"

#include "BmlHodUsbDevice.hh"
#include "BmlHodReadout.hh"
//#include "MessageDriver.hh"

//#include "DevbRS232.hh"
//#include "BendRS232.hh"
//#include "FendRS232.hh"
//#include "FesRS232.hh"

using namespace std;

int main(int argc, const char **argv) {
  BmlHodUsbDevice usbDriver("/dev/ttyUSB0");
  BmlHodReadout hod(usbDriver);

  RcdArena arena;
  SubAccessor accessor(arena);

  arena.deleteData();
  arena.updateRecordTime();
  arena.recordType(RcdHeader::runStart);

  hod.record(arena);
  std::vector<const BmlHodRunData*> v(accessor.extract<BmlHodRunData>());
  assert(v.size()==1);
  v[0]->print(cout);

  while(true) {
    hod.reset();
    cout << "Hodoscope has trigger unset" << endl;
    
    hod.triggerPoll();
    cout << "Hodoscope has trigger set" << endl;

    arena.deleteData();
    arena.updateRecordTime();
    arena.recordType(RcdHeader::event);
    
    hod.record(arena);
    std::vector<const BmlHodEventData*> ve(accessor.extract<BmlHodEventData>());
    assert(ve.size()==1);
    ve[0]->print(cout) << std::endl;
  }
    
  return 0;
}
