/***********************************************************************
 commandClient
 ***********************************************************************/
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>

#include <ctime>
#include <cstring>
#include <iostream>

#include "CommandClient.hh"
#include "BufferStatus.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"
#include "SocketPorts.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"

bool usr1Seen(false);
bool looping(true);

void usrSH(int signal) {
  if(signal==SIGUSR1) usr1Seen=true;
  else usr1Seen=false;
  if(signal==SIGTERM) looping=false;
}

using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  CommandClient client;
  //  string ipNumber("134.79.128.179");
  string ipNumber("155.198.211.15");

  try {
    DuplexSocket dSock(ipNumber,COMMANDPORT,1000);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Client socket initialised" << endl;
    dSock.print(cout);
      
    pid_t childPid(fork());
    if(childPid!=0) {
      client.childPid(childPid);
      while(looping) {
	const char *s;
	s=client.send();
	cout << argv[0] << " Parent " << ctime(&(t=time(0)));
	cout << " Sending " << s << endl;
	if(s[0]=='q') looping=false;
	dSock.send(s,strlen(s));
      }
      kill(childPid,SIGTERM);

    } else {
      signal(SIGUSR1,usrSH);
      signal(SIGUSR2,usrSH);
      signal(SIGTERM,usrSH);
      while(looping) {
	if(usr1Seen) sleep(0x7fffffff);
	char s[16];
	dSock.recv(s,16);
	client.recv(s);
      }
    }
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Shutdown command seen" << endl;
    
  } catch(SocketException &e) {
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Exception was caught: " << e.description() << endl;
  }
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
