/***********************************************************************
 commandServer
 ***********************************************************************/

#include <ctime>
#include <cstring>
#include <iostream>

#include "CommandServer.hh"
#include "BufferStatus.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"
#include "SocketPorts.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"


using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  CommandServer server;

  try {
    DuplexSocket dSock(COMMANDPORT);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Server socket initialised" << endl;
    dSock.print(cout);
      
    if(fork()!=0) {
      while(true) {
	char s[16];
	dSock.recv(s,16);
	cout << argv[0] << " Parent " << ctime(&(t=time(0)));
	cout << " Received " << s[0] << endl;
	server.recv(s);
      }
    } else {
      while(true) {
	const char *s;
	s=server.send();
	cout << argv[0] << " Child " << ctime(&(t=time(0)));
	cout << " Sending " << s << endl;
	dSock.send(s,strlen(s));
	sleep(1);
      }
    }
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Shutdown command seen" << endl;
    
  } catch(SocketException &e) {
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Exception was caught: " << e.description() << endl;
  }
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
