#include <ctime>
#include <iostream>

#include "Control.hh"
#include "RecordBuffer.hh"
#include "ShmSingleton.hh"

using namespace std;

main(int argc, char *argv[]) {
  ShmSingleton<Control> shmC;
  Control* c(shmC.payload());

  if(c==0) {
    cerr << argv[0] << ": null pointer for ShmSingleton<Control>" << endl;
    return 1;
  }

  ShmSingleton<RecordBuffer> shmE;
  RecordBuffer* e(shmE.payload());

  if(e==0) {
    cerr << argv[0] << ": null pointer for ShmSingleton<RecordBuffer>" << endl;
    return 1;
  }

  cout << argv[0] << ": all shared memory attached" << endl;


  while(!(c->command() == Control::kill)) {
    unsigned n(0);
    EventData *p;
    while((p=e->getMonEvent())!=0 || c->run()) {
      if(p!=0) {
	unsigned t(p->eventTime());
	cout << argv[0] << ": event number " << p->eventNumber()
	     << " time " << ctime((const time_t*)&t);

	unsigned short *d(p->ecalData());
	cout << hex;
	for(unsigned i(0);i<16;i++) {
	  cout << " " << d[i];
	}
	cout << dec << endl;

	e->releaseMonEvent();
      }
      sleep(1);
    }
    sleep(1);
  }

  cout << argv[0] << ": kill command seen" << endl;
  return 0;
}
