// g++ -I../../../dual/inc/rcd -I../../../dual/inc/sub -I../../inc/sem -I../../inc/skt -I../../inc/shm -I../../inc/dio -I../../inc/onl partialWriter.cc -o partialWriter -lpthread

// With ROOT
// g++ `$ROOTSYS/bin/root-config --cflags` -I../../../dual/inc/rcd -I../../../dual/inc/sub -I../../../dual/inc/daq -I../../inc/sem -I../../inc/skt -I../../inc/shm -I../../inc/dio -I../../inc/onl monitorTest2.cc -o monitorTest2 `$ROOTSYS/bin/root-config --new --libs`

#include <unistd.h>
#include <cstdio>
#include <pthread.h>

#include <iostream>

#include "DioSocketProducer.hh"
#include "DioMultiConsumer.hh"
#include "DioMultiProducer.hh"
#include "DioThread.hh"
#include "OnlReader.hh" // TEMP!!!
#include "OnlSocketProducer.hh"
#include "OnlWriter.hh"
#include "OnlSampler.hh"
#include "OnlMonitor.hh"

using namespace std;

int main() {
  OnlSocketProducer p("localhost",12330,1000);
  OnlMonitor h;

  DioThread<RcdArena> t0(p,h);
  t0.create();
  t0.join();

  return 0;
}
