#include <unistd.h>
#include <cstdio>
#include <pthread.h>

#include <iostream>

#include "DioSocketProducer.hh"
#include "DioSocketConsumer.hh"
#include "DioConnector.hh"
#include "DioBuffer.hh"
#include "DioThread.hh"
#include "RcdArena.hh"

using namespace std;

int main() {
  DioSocketProducer<RcdArena> sp("localhost",12333,1000);
  DioConnector<RcdArena> r;
  DioBuffer<RcdArena> b(34563);
  DioSocketConsumer<RcdArena> sc("localhost",12343,1000);

  DioThread<RcdArena> t0(sp,r);
  t0.create();
  DioThread<RcdArena> t1(r,b);
  t1.create();
  DioThread<RcdArena> t2(b,sc);
  t2.create();

  t0.join();
  t1.join();
  t2.join();

  return 0;
}
