/***********************************************************************
 readerDirect
 ***********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
 
#include <iostream>
#include <fstream>

#include "ReaderServer.hh"
#include "ReaderClient.hh"

using namespace std;

bool loop(true);

void termSignalHandler(int signal) {
  cout << "Process " << getpid() << " received signal " << signal << endl;
  loop=false;
}

main(int argc, char *argv[]) {
  //  signal(SIGTERM,termSignalHandler);

  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << flush << endl;

  ReaderServer server;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Constructed server" << flush << endl;

  ReaderClient client;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Constructed client" << flush << endl;


  while(loop) {
    //client.recv(server.send());
    //server.recv(client.send());

    Record *r(client.send());
    if(r->recordType()==RecordHeader::shutDown) loop=false;
    server.recv(r);
    
    bool reply(server.send());
    client.recv(reply);
  }

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << flush << endl;
  return 0;
}
