/***********************************************************************
 readerServer
 ***********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "RecordArray.hh"
#include "SocketPorts.hh"
#include "ReaderServer.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  ReaderServer server;

  try {
    DuplexSocket dSock(READERPORT);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Server socket initialised" << endl;
    dSock.print(cout);
 
    RecordArray<MAXRECORDARRAY> a;
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " sizeof(RecordArray<MAXRECORDARRAY>) = " 
	 <<   sizeof(RecordArray<MAXRECORDARRAY>) << endl;
    Record *r(&a);

    while(true) {
      dSock.recv(r,1);
      server.recv(r);
      bool error(server.send());
      dSock.send(&error,1);
    }

  } catch(SocketException &e) {
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Exception was caught: " << e.description() << endl;
  }

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
