/***********************************************************************
 writer - takes events from shared memory buffer and writes to disk
***********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "Record.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  unsigned servers(7);
  if(argc>2) sscanf(argv[2],"%u",&servers);
  cout << argv[0] << ": Servers set to 0x" << hex << servers << dec << endl;
  if((servers&7)==0) return 0;

  const unsigned nSock(3);
  DuplexSocket *dSock[nSock];
 
  try {
    dSock[0]=0;
    if((servers&1)!=0) {
      //      dSock[0]=new DuplexSocket("155.198.211.15",30002,1000); // lx08
      dSock[0]=new DuplexSocket("134.79.128.179",30002,1000); // pilsner
      cout << argv[0] << ": Client socket 0 initialised ";
      dSock[0]->print(cout);
    }

    dSock[1]=0;
    if((servers&2)!=0) {
      //      dSock[1]=new DuplexSocket("155.198.211.16",30002,1000); // lx09
      dSock[1]=new DuplexSocket("134.79.113.171",30002,1000); // marzen
      cout << argv[0] << ": Client socket 1 initialised ";
      dSock[1]->print(cout);
    }

    dSock[2]=0;
    if((servers&4)!=0) {
      //      dSock[2]=new DuplexSocket("155.198.211.16",30002,1000); // lx09
      dSock[2]=new DuplexSocket("134.79.112.73",30002,1000); // icstmpc1
      cout << argv[0] << ": Client socket 2 initialised ";
      dSock[2]->print(cout);
    }

    ofstream *pout(0);

    int reply(5678);
    unsigned array[2048];
    Record *r((Record*)array);
    *r=Record();

    while(r->recordType()!=RecordHeader::shutDown) {

      for(int i(0);i<nSock;i++) {
	if(dSock[i]!=0) {
	  dSock[i]->recv(r,1);
	  dSock[i]->send(&reply,1);
	  r->print(cout);
	  // SHOULD MERGE RECORDS HERE
	}
      }

      switch (r->recordType()) {
      case RecordHeader::startOfRun:
	if(pout!=0) {
	  cerr << argv[0] << ": Output file pointer non-zero at startOfRun" << endl;
	  cout << argv[0] << ": New run: number " << r->runNumber() 
	       << " closing old file" << endl;
	  delete pout;
	}
	
	char file[128];
	sprintf(file,"dat/run%06.6u.dat",r->runNumber());
	pout=new ofstream(file,ios::out);
	if(pout==0 || !(*pout)) {
	  cerr << argv[0] << ": Error opening file " << file << endl;
	  
	} else {
	  cout << argv[0] << ": New run: number " << r->runNumber() 
	       << " writing to file " << file << endl;
	  r->write(*pout);
	}
	break;
	
      case RecordHeader::endOfRun:
	if(pout!=0) {
	  r->write(*pout);
	  cout << argv[0] << ": End run: number " << r->runNumber() 
	       << " closing file" << endl;
	  delete pout;
	  pout=0;
	} else {
	  cerr << argv[0] << ": Output file pointer zero at endOfRun" << endl;
	}
	break;
	
      case RecordHeader::startOfConfiguration:
      case RecordHeader::startOfSpill:
      case RecordHeader::event:
      case RecordHeader::stopRun:
      case RecordHeader::endOfSpill:
      case RecordHeader::endOfConfiguration:
	if(pout!=0) {
	  r->write(*pout);
	}
	break;
	
      default:
	break;
      };   
    }
    
    if(pout!=0) {
      delete pout;
      cerr << argv[0] << ": Output file pointer non-zero at shutDown" << endl;
    }
    
    cout << argv[0] << ": kill command seen" << endl;

  } catch ( SocketException& e ) {
    std::cout << "Exception was caught:" << e.description() << "\nExiting.\n";
  }

  delete dSock[0];
  delete dSock[1];
  delete dSock[2];
 
  return 0;
}
