/***********************************************************************
 socketServerCommander
***********************************************************************/

#include <ctime>
#include <iostream>

#include "Command.hh"
#include "ShmSingleton.hh"
#include "ListenerSocket.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  ShmSingleton<Command> shmC;
  Command* c(shmC.payload());

  if(c==0) {
    cerr << argv[0] << ": Null pointer for ShmSingleton<Command>" << endl;
    return 1;
  }

  cout << argv[0] << ": All shared memory attached" << endl;

  try {
    ListenerSocket lSock(30000);
    cout << argv[0] << ": Listener socket initialised ";
    lSock.print(cout);

    while(!(c->command() == Command::kill)) {
      //      try {
	DuplexSocket dSock(lSock);
	cout << argv[0] << ": Server socket initialised" << endl;
	dSock.print(cout);
	
	while(!(c->command() == Command::kill)) {
	  dSock.recv(c,1);
	  while(!(c->command() == Command::null)) {
	    cout << argv[0] << ": Sleeping" << endl;
	    sleep(1);
	  }
	  dSock.send(c,1);
	}
	//      } catch ( SocketException& e ) {
	//	std::cout << "Exception was caught:" << e.description() << endl;
	//      }
    }
    
  } catch ( SocketException& e ) {
    std::cout << "Exception was caught:" << e.description() << "\nExiting.\n";
  }

  return 0;
}
