#include <iostream>

#include "Command.hh"
#include "RecordBuffer.hh"
#include "VmeCrate.hh"
#include "VmeInterrupt.hh"
#include "ShmSingleton.hh"

using namespace std;

main(int argc, char *argv[]) {
  ShmSingleton<Command> shmC;
  Command* c(shmC.payload());
  c->reset();
  cout << argv[0] << ": ShmSingleton<Command> initialised" << endl;

  ShmSingleton<RecordBuffer> shmR;
  RecordBuffer* r(shmR.payload());
  r->reset();
  cout << argv[0] << ": ShmSingleton<RecordBuffer> initialised" << endl;

  ShmSingleton<VmeCrate> shmV;
  VmeCrate* v(shmV.payload());
  v->reset();
  cout << argv[0] << ": ShmSingleton<VmeCrate> initialised" << endl;

  ShmSingleton<VmeInterrupt> shmI;
  VmeInterrupt* i(shmI.payload());
  i->reset();
  cout << argv[0] << ": ShmSingleton<VmeInterrupt> initialised" << endl;

  return 0;
}
