#include <cmath>
#include <cstdlib>
#include <iostream>

#include "Control.hh"
#include "VmeCrate.hh"
#include "ShmSingleton.hh"

using namespace std;

double flatRandom() {
  return double(rand())/RAND_MAX;
}

double gaussianRandom() {
  double x,y;
  do {
    x = 10.0*(flatRandom()-0.5); 
    y = exp(-x*x/2.0);
  } while(flatRandom()>y);
  return x;
}

main(int argc, char *argv[]) {
  ShmSingleton<Control> shmC;
  Control* c(shmC.payload());

  if(c==0) {
    cerr << argv[0] << ": null pointer for ShmSingleton<Control>" << endl;
    return 1;
  }

  ShmSingleton<VmeCrate> shmV;
  VmeCrate* v(shmV.payload());

  if(v==0) {
    cerr << argv[0] << ": null pointer for ShmSingleton<VmeCrate>" << endl;
    return 1;
  }

  cout << argv[0] << ": all shared memory attached" << endl;

  unsigned printLevel(0);
  if(argc>1) sscanf(argv[1],"%u",&printLevel);
  cout << argv[0] << ": print level set to " << printLevel << endl;


  double pedestal(1000.0);
  double noise(10.0);  // 0.1 MIP as 1 MIP = 100, full range ~600 MIPs
  double calibrationGain(1.1);


  unsigned n(0);
  while(c->command() != Control::kill) {
    if(!v->readyForReadout()) {
      if(v->externalTrigger()) v->trigger(true);
      while(!v->trigger()); // Fail???

      //      unsigned delay = 0;//unsigned(-100.0*log(flatRandom()));
      //      usleep(delay);

      if((printLevel==0 && (n%10000)==0) ||
	 (printLevel==1 && (n%1000 )==0) ||
	 (printLevel==2 && (n%100  )==0) ||
	 (printLevel==3 && (n%10   )==0) ||
	 (printLevel>=4)) cout << argv[0] << ": event " << n << endl;

      n++;

      for(unsigned i(0);i<15;i++) {
	VmeReadoutBoard *p(v->vmeReadoutBoard(i));
	RobConfiguration *robc(p->robConfiguration());
	RobEvent *robe(p->robEvent());

	for(unsigned pcb(0);pcb<6;pcb++) {
	  PcbConfiguration *w(robc->pcbConfiguration(pcb));
	  PcbEvent *x(robe->pcbEvent(pcb));
	  unsigned short *q(x->channels());

	  for(unsigned j(0);j<108;j++) {
	    double signal(pedestal+noise*gaussianRandom()+0.5);
	    if(w->calibrationEnable() && 
	       w->calibrationSelection(w->calibrationGroup(j))) {
	      double t(w->sahDelay()/18.0);
	      signal+=t*exp(1.0-t)*calibrationGain*w->calibrationDacValue();
	    }
	    if(signal<  500.5) signal=  500.5;
	    if(signal>65000.5) signal=65000.5;
	    q[108*pcb+j]=(unsigned short)signal;
	  }
	}
	p->readyForReadout(true);
      }
    }
  }
  return 0;
}
