#include <sys/time.h>
#include <unistd.h>

#include <ctime>
#include <iostream>

#include "TimeVal.hh"
#include "VmeInterrupt.hh"
#include "ShmSingleton.hh"

using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  TimeVal tv;
  tv.print(cout);
  cout << "size = " << sizeof(TimeVal) << " " << tv << endl;

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << flush << endl;
 
  ShmSingleton<VmeInterrupt> shmI;
  VmeInterrupt *i(shmI.payload());
  i->print(cout);
  if(!i->setProducerPid()) {
    cerr << argv[0] << " " << ctime(&(t=time(0)));
    cerr << " Cannot register with ShmSingleton<VmeInterrupt>" 
	 << flush << endl;
  }
  i->print(cout);

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " ShmSingleton<VmeInterrupt> initialised" << endl;

  while(true) {
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Starting spill" << endl;

    i->spill(true);
    unsigned s(time(0));
    unsigned nTry(0),nTrg(0);

    while((time(0)-s)<4) {
      nTry++;
      if(!i->trigger()) {
	nTrg++;
	i->trigger(true);
	i->signalConsumer();
	i->enableProducerSignal();
	sleep(1);
	i->disableProducerSignal();
      }
      //      usleep(1000);
    }

    i->spill(false);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Number of triggers within spill " << nTrg << "/" << nTry << endl;
    sleep(5);
  }

  return 0;
}
