/***********************************************************************
 writerClient
 ***********************************************************************/

#include <cstdio>
#include <ctime>
#include <iostream>

#include "WriterClient.hh"
#include "Record.hh"
#include "SocketPorts.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  const unsigned nSock(3);

  unsigned servers(7);
  if(argc>1) sscanf(argv[1],"%u",&servers);
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Servers set to 0x" << hex << servers << dec << endl;
  if((servers&7)==0) return 0;

  string ipNumber[nSock];
  ipNumber[0]="134.79.128.179"; // pilsner
  ipNumber[1]="134.79.113.171"; // marzen
  ipNumber[2]="134.79.112.73" ; // icstmpc1
  //"155.198.211.15"; // lx08
  //"155.198.211.16"; // lx09

  DuplexSocket dSock[nSock];

  try {
    for(int i(0);i<nSock;i++) {
      if((servers&(1<<i))!=0) {
	dSock[i].initialise(ipNumber[i],WRITERPORT,1000);
	cout << argv[0] << " " << ctime(&(t=time(0)));
	cout << " Client socket " << i << " initialised" << endl;
	dSock[i].print(cout);
      }
    }
    
    Record r[nSock];
    WriterClient client;
    
    bool shutDown(false);
    while(!shutDown) {
      cout << argv[0] << " " << ctime(&(t=time(0)));

      for(int i(0);i<nSock;i++) {
	if(dSock[i].usable()) {
	  dSock[i].recv(r+i,1);

	  cout << " Socket " << i << endl;
	  client.recv(r+i);

	  //MERGE???

	  bool error(client.send());
	  dSock[i].send(&error,1);
	}
      }
    }

    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Shutdown command seen" << endl;

  } catch(SocketException &e) {
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Exception was caught: " << e.description() << endl;
  }

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
