/***********************************************************************
 writerDirect
 ***********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
 
#include <iostream>
#include <fstream>

#include "WriterServer.hh"
#include "WriterClient.hh"

using namespace std;

bool loop(true);

void termSignalHandler(int signal) {
  cout << "Process " << getpid() << " received signal " << signal << endl;
  loop=false;
}

main(int argc, char *argv[]) {
  signal(SIGTERM,termSignalHandler);

  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << flush << endl;

  WriterServer server;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Constructed server" << flush << endl;

  WriterClient client;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Constructed client" << flush << endl;


  while(loop) {
    //client.recv(server.send());
    //server.recv(client.send());

    Record *r(server.send());
    cout << argv[0] << " " << ctime(&(t=time(0)));
    if(r!=0) r->print(cout);
    cout << flush;

    client.recv(r);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Client recv" << flush << endl;

    bool reply(client.send());
    cout << argv[0] << " " << ctime(&(t=time(0)));
    if(reply) cout << " Client send true" << flush << endl;
    else      cout << " Client send false" << flush << endl;

    server.recv(reply);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Server recv" << flush << endl;
  }

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << flush << endl;
  return 0;
}
