/***********************************************************************
 writerServer
 ***********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include <iostream>
#include <fstream>

#include "SocketPorts.hh"
#include "WriterServer.hh"
#include "DuplexSocket.hh"

using namespace std;

main(int argc, char *argv[]) {
  time_t t;
  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Starting" << endl;

  WriterServer server;

  try {
    DuplexSocket dSock(WRITERPORT);
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Server socket initialised" << endl;
    dSock.print(cout);
 
    while(true) {
      dSock.send(server.send(),1);
      bool error(false);
      dSock.recv(&error,1);
      server.recv(error);
    }

  } catch(SocketException &e) {
    cout << argv[0] << " " << ctime(&(t=time(0)));
    cout << " Exception was caught: " << e.description() << endl;
  }

  cout << argv[0] << " " << ctime(&(t=time(0)));
  cout << " Exiting" << endl;
  return 0;
}
