#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdArena.hh"
#include "RcdWriterAsc.hh"
#include "RcdWriterBin.hh"
#include "RcdWriterDmy.hh"
#include "DaqRunStart.hh"

#include "SubExtracter.hh"

#include "CrcLocationData.hh"
#include "CrcReadout.hh"
#include "CrcReadoutConfigurationData.hh"
#include "OnlCounter.hh"
#include "HstNoise.hh"

using namespace std;


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);
  //argh.print(cout);
  
  const bool doCheck(argh.option('c',"Run data check"));
  const bool doHistograms(argh.option('s',"Display histograms"));
  const bool doGraphics(argh.option('g',"Display graphics"));
  const bool useIntTrigger(argh.option('i',"Internal trigger selection"));
  
  const unsigned printLevel(argh.optionArgument('p',5,"Print level"));
  const unsigned feMask(argh.optionArgument('f',0xff,"FE mask"));
  const unsigned nEvents(argh.optionArgument('n',10,"Number of events between updates"));
  
  if(argh.help()) return 0;
  
  if(doCheck) cout << "Data check selected" << endl;
  else           cout << "Data check not selected" << endl;
  if(doHistograms) cout << "Histograms display selected" << endl;
  else           cout << "Histograms display not selected" << endl;
  if(doGraphics) cout << "Graphics display selected" << endl;
  else           cout << "Graphics display not selected" << endl;
  if(useIntTrigger) cout << "Internal trigger selected" << endl;
  else              cout << "External trigger selected" << endl;
  
  cout << "Print level set to " << printLevel << endl;
  cout << "FE mask set to " << printHex((unsigned char)feMask) << endl;
  cout << "Number of events set to " << nEvents << endl;
  
  // Define the CERC locations
  unsigned char theCrate(0xec);
  const unsigned nSlots(4);
  unsigned theSlots[nSlots]={6,10,14,18};
  //const unsigned nSlots(1);
  //unsigned theSlots[nSlots]={14};
  
  // Open output file
  ostringstream sout;
  sout << "typ/Rtp" << time();

  RcdWriterAsc writer;
  //RcdWriterBin writer;
  //RcdWriterDmy writer;
  writer.open(sout.str());
  
  // Create area for records
  RcdArena arena;
  SubInserter inserter(arena);

  // Set RunStart
  arena.deleteData();
  //arena.updateRecordTime(); Leave time as zero!
  arena.recordType(SubHeader::runStart);

  const unsigned nCfg(32);

  // Put in run information
  DaqRunStart drs;
  drs.runNumber(0);
  drs.maximumNumberOfConfigurationsInRun(nCfg);
  drs.maximumNumberOfEventsInRun(32*1024);
  drs.maximumNumberOfSpillsInRun(drs.maximumNumberOfEventsInRun());
  drs.print(cout) << endl;

  inserter.insert<DaqRunStart>(drs);
  writer.write(&arena);
  
  // Loop over configurations
  for(unsigned iConfiguration(0);iConfiguration<nCfg;iConfiguration++) {

    // Set RunStart
    arena.deleteData();
    //arena.updateRecordTime(); Leave time as zero!
    arena.recordType(SubHeader::configurationStart);
      
    // Put in configuration information
    DaqRunStart dcs;
    dcs.runNumber(0);
    dcs.maximumNumberOfConfigurationsInRun(nCfg);
    dcs.maximumNumberOfEventsInRun(32*1024);
    dcs.maximumNumberOfSpillsInRun(drs.maximumNumberOfEventsInRun());
    dcs.print(cout) << endl;

    inserter.insert<DaqConfigurationStart>(dcs);
    writer.write(&arena);
  
      
      // Add readout control
      CrcReadoutConfigurationData
	*b(inserter.insert<CrcReadoutConfigurationData>());
      *b=CrcReadoutConfigurationData();
      b->vmePeriod(1);
      b->bePeriod(1);
      b->fePeriod(1);
      b->beTrgMode(0);
      b->vlinkMode(3);
      b->print(std::cout) << std::endl;
      
      for(unsigned i(0);i<nSlots;i++) {
	CrcLocationData<CrcBeConfigurationData>
	  *b(inserter.insert< CrcLocationData<CrcBeConfigurationData> >());
	b->crateNumber(theCrate);
	b->slotNumber(theSlots[i]);
	b->crcComponent(CrcLocation::be);
	b->label(1);
	
	*b->data()=CrcBeConfigurationData();
	b->data()->mode(0x02);
	b->data()->test(0x00);
	b->data()->testLength(0);
	b->print(std::cout) << std::endl;
	
	// Only do BE-Trg for first board
	if(i==0) {
	  CrcLocationData<CrcBeTrgConfigurationData>
	    *bt(inserter.insert< CrcLocationData<CrcBeTrgConfigurationData> >());
	  bt->crateNumber(theCrate);
	  bt->slotNumber(theSlots[i]);
	  bt->crcComponent(CrcLocation::beTrg);
	  bt->label(1);
	  
	  *bt->data()=CrcBeTrgConfigurationData();
	  //
	  bt->data()->inputEnable(1<<24);
	  //bt->data()->oscillationPeriod(40000000); // 1 sec
	  //bt->data()->oscillationPeriod(4000000); // 0.1 sec
	  bt->data()->oscillationPeriod(400000); // 0.01 sec
	  //bt->data()->oscillationPeriod(40000); // 0.001 sec
	  bt->print(std::cout) << std::endl;
	}
	
	for(unsigned f(0);f<8;f++) {
	  CrcLocationData<CrcFeConfigurationData>
	    *b(inserter.insert< CrcLocationData<CrcFeConfigurationData> >());
	  b->crateNumber(theCrate);
	  b->slotNumber(theSlots[i]);
	  b->crcComponent((CrcLocation::CrcComponent)f);
	  b->label(1);
	  
	  *b->data()=CrcFeConfigurationData();
	  unsigned nadc=18;
	  b->data()->holdDuration(nadc*4*700);
	  b->data()->vfeMplexClockPulses(nadc);
	  b->data()->vfeTopGain(true);
	  b->data()->vfeBotGain(true);
	  b->data()->adcControl(8);// 8 = No DAC, 9 = DAC
	  b->data()->dacData(0,0);
	  b->data()->dacData(1,0);
	  b->data()->frameSyncDelay(16);
	  b->data()->qdrDataDelay(0); // 0 = Normal, 1 = FakeEvent
	  b->print(std::cout) << std::endl;
	  
	  CrcLocationData<CrcFeFakeEventData>
	    *be(inserter.insert< CrcLocationData<CrcFeFakeEventData> >());
	  be->crateNumber(theCrate);
	  be->slotNumber(theSlots[i]);
	  be->crcComponent((CrcLocation::CrcComponent)f);
	  be->label(1);
	  
	  be->data()->numberOfWords(32);
	  be->data()->enable(false);
	  unsigned *fe(be->data()->data());
	  for(unsigned ie(0);ie<be->data()->numberOfWords();ie++) {
	    if((ie%2)==0) fe[ie]=((~((  f)*8192+ie))<<16)&0xffff0000|((7-f)*8192+ie);
	    else          fe[ie]=((~((7-f)*8192+ie))<<16)&0xffff0000|((  f)*8192+ie);
	  }
	  inserter.extend(be->data()->numberOfWords()*4);
	  
	  be->print(std::cout) << std::endl;
	}
      }
      
      writer.write(&arena);
      
      od.readout(arena,SubHeader::spillStart);
      writer.write(&arena);
    }
  }
}
