#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "HardwareAccessException.hh"

#include "DaqBusAdapter.hh"
#include "CrcVmeDevice.hh"
#include "UtlArguments.hh"

using namespace std;


unsigned readDataBuffer(CrcVmeDevice &dev, unsigned short *buffer) {
  unsigned long n(0);

  //sleep(1);

  unsigned nBuffer(0);

  bool empty(false);
  for(unsigned j(0);j<5000 && !empty;j++) {
    dev.read("SystemAceStatusRegLSBs",&n);
    //std::cout << "SystemAceStatusRegLSBs " << printHex((unsigned)n) << std::endl;
    UtlPack s2(n);
    if(s2.bit(5)) {
      for(unsigned i(0);i<16;i++) {
	dev.read("SystemAceDataBufReg",&n);
	nBuffer++;
	buffer[nBuffer]=n&0xffff;
	//if(n!=0)
	//std::cout << "SystemAceDataBufReg  " << std::setw(4) << j << " " << std::setw(2) << i 
	//	<< " " << printHex((unsigned)n) << std::endl;
	
      }
      
      //dev.read("SystemAceSecCntCmdReg",&n);
      //std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
      
    } else {
      empty=true;
      std::cout << "Empty set for j = " << j << std::endl;
    }
  }

  return nBuffer;
}

int main(int argc, const char **argv) {

  UtlArguments argh(argc,argv);

  /*** */
  const bool readImage(argh.option('r',true,"Read CF image"));
  const bool useFile(argh.option('u',true,"Use CF image file"));
  const unsigned slotNumber(argh.optionArgument('s',9,"Slot number"));
  const unsigned pciNumber(argh.optionArgument('p',0,"PCI card number"));
  const std::string fileName(argh.optionArgument('f',"/tmp/crc.img","CF image file name"));
  /* ***/

  if(argh.help()) return 0;


  VMEAddressTableASCIIReader addressTableReader("online/hal/CrcVmeAddress.hal");
  VMEAddressTable addressTable("CRC VME Address Table",addressTableReader);

  try{
    DaqBusAdapter busAdapter(pciNumber);
    cout << "PCI card " << pciNumber << " is alive" << endl;
    
    CrcVmeDevice dev(addressTable,busAdapter,slotNumber);
    if(dev.alive()) {
      cout << "  CRC at slot "
	   << setw(2) << slotNumber << " is alive" << endl;


      unsigned long n(0);

      unsigned nBuffer(0);
      unsigned short *buffer=new unsigned short[8*1024*1024];
      

      dev.systemAcePrint(std::cout);
      
      std::cout << std::endl << "Trying to abort" << std::endl;  
      
      dev.read("SystemAceSecCntCmdReg",&n);
      std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
      
      dev.write("SystemAceSecCntCmdReg",0);
      dev.read("SystemAceSecCntCmdReg",&n);
      std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
      
      if(n!=0) dev.write("SystemAceSecCntCmdReg",0x600);
      sleep(1);
      dev.read("SystemAceSecCntCmdReg",&n);
      std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
      
      readDataBuffer(dev,buffer);
      dev.read("SystemAceSecCntCmdReg",&n);
      std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
      
      dev.write("SystemAceSecCntCmdReg",0);
      dev.read("SystemAceSecCntCmdReg",&n);
      std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
      
      std::cout << std::endl << "Resetting" << std::endl;  
      dev.write("SystemAceControlRegLSBs",0x00);
      dev.write("SystemAceControlRegLSBs",0x80);
      // ***sleep(5);
      dev.write("SystemAceControlRegLSBs",0x00);
      sleep(5);      

      dev.systemAcePrint(std::cout);

      /***MW */
      /*
      readDataBuffer(dev,buffer);
      dev.systemAceReset();
      dev.systemAcePrint(std::cout);
      */
      
      std::cout << std::endl << "Writing 1 to SystemAceBusModeReg" << std::endl;  
      dev.write("SystemAceBusModeReg",1);
      dev.systemAcePrint(std::cout);

      if(readImage) {
	if(useFile) {
	  dev.systemAceReadCfImage(fileName);
	} else {
	  std::vector<unsigned short> v;
	  dev.systemAceReadCfImage(v);
	}
      } else {
	dev.systemAceWriteCfImage(fileName);
      }
      
      /*
      UtlPack maxLba(0);
      dev.read("SystemAceCfgLbaRegLSBs",&n);
      maxLba.halfWord(0,n&0xffff);
      dev.read("SystemAceCfgLbaRegMSBs",&n);
      maxLba.halfWord(1,n&0xffff);
      
      
      std::cout << std::endl << "Reading " << maxLba.word() << " lbas" << std::endl;  
      
      nBuffer=0;
      
      for(unsigned lba(0);lba<=maxLba.word();lba+=256) {
	
	// Now get lock
	std::cout << std::endl << "Trying to get lock" << std::endl;
	
	dev.read("SystemAceControlRegLSBs",&n);
	std::cout << "SystemAceControlRegLSBs " << printHex((unsigned)n) << std::endl;
	
	UtlPack u(n);
	u.bit(1,true);
	dev.write("SystemAceControlRegLSBs",u.word());
	
	dev.read("SystemAceControlRegLSBs",&n);
	std::cout << "SystemAceControlRegLSBs " << printHex((unsigned)n) << std::endl;
	
	// sleep(5);
	
	dev.pollItem("SystemAceLockStatus",0x3,5000,&n);
	dev.read("SystemAceStatusRegLSBs",&n);
	std::cout << "SystemAceStatusRegLSBs  " << printHex((unsigned)n) << std::endl;

	UtlPack s(n);
	if(s.bit(1)) {
	  if(s.bit(8)) {
	    
	    std::cout << std::endl << "Trying to set lba " << lba << std::endl;
	    
	    UtlPack ul(lba);
	    //if(lba==0) {
	    dev.write("SystemAceMpuLbaRegLSBs",ul.halfWord(0));
	    dev.write("SystemAceMpuLbaRegMSBs",ul.halfWord(1));
	    //}
	    dev.write("SystemAceSecCntCmdReg",0x300);
	    
	    dev.read("SystemAceMpuLbaRegLSBs",&n);
	    std::cout << "SystemAceMpuLbaRegLSBs" << printHex((unsigned)n) << std::endl;
	    dev.read("SystemAceMpuLbaRegMSBs",&n);
	    std::cout << "SystemAceMpuLbaRegMSBs" << printHex((unsigned)n) << std::endl;
	    dev.read("SystemAceSecCntCmdReg",&n);
	    std::cout << "SystemAceSecCntCmdReg" << printHex((unsigned)n) << std::endl;
	    
	    dev.pollItem("SystemAceStatusRegDataBufRdy",0x1,5000,&n);
	    
	    unsigned nB=readDataBuffer(dev,buffer+nBuffer);
	    std::cout << "First word read = " << printHex(buffer[nBuffer]) << std::endl;
	    nBuffer+=nB;
	    std::cout << "Buffer size = " << nBuffer << std::endl;
	    
	    //dev.write("SystemAceSecCntCmdReg",0x600);
	    
	  } else {
	    std::cout << std::endl << "Not ready for commands!" << std::endl;
	  }
	  
	  sleep(1);
	  
	  std::cout << std::endl << "Trying to release lock" << std::endl;
	  
	  dev.read("SystemAceControlRegLSBs",&n);
	  std::cout << "SystemAceControlRegLSBs " << printHex((unsigned)n) << std::endl;
	  
	  u=n;
	  u.bit(0,false);
	  u.bit(1,false);
	  
	  dev.write("SystemAceControlRegLSBs",u.word());
	  dev.read("SystemAceControlRegLSBs",&n);
	  std::cout << "SystemAceControlRegLSBs " << printHex((unsigned)n) << std::endl;
	  dev.read("SystemAceStatusRegLSBs",&n);
	  std::cout << "SystemAceStatusRegLSBs  " << printHex((unsigned)n) << std::endl;
	  
	} else {
	  std::cout << std::endl << "Not MPU locked!" << std::endl;
	  
	  sleep(1);
	  
	  std::cout << std::endl << "Force resetting" << std::endl;  
	  dev.write("SystemAceControlRegLSBs",0x83);
	  sleep(1);
	  dev.write("SystemAceControlRegLSBs",0x00);
        }

		
      }
      */

      /*      
      int _fileDescriptor1=creat("cf1.bin",O_WRONLY);
      int _fileDescriptor2=creat("cf2.bin",O_WRONLY);
      unsigned char c[2];
      for(unsigned i(0);i<nBuffer;i++) {
	if(i<32) std::cout << "Buffer[" << std::setw(6) << i << "] = " << printHex(buffer[i]) << std::endl;
	
	c[0]=buffer[i]&0xff;
	c[1]=buffer[i]>>8;
	
	write(_fileDescriptor1,c+0,1);
	write(_fileDescriptor1,c+1,1);
	write(_fileDescriptor2,c+1,1);
	write(_fileDescriptor2,c+0,1);
      }
      
      close(_fileDescriptor1);
      close(_fileDescriptor2);
      */
    }
    
    return 0;
    
    
  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << " I Made This" << endl;
    
  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
}
