#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "HardwareAccessException.hh"

#include "DaqBusAdapter.hh"
#include "CrcVmeDevice.hh"
#include "UtlArguments.hh"

using namespace std;


int main(int argc, const char **argv) {

  UtlArguments argh(argc,argv);

  const unsigned slotNumber(argh.optionArgument('s',9,"Slot number"));
  const unsigned pciNumber(argh.optionArgument('p',0,"PCI card number"));

  if(argh.help()) return 0;


  VMEAddressTableASCIIReader addressTableReader("online/hal/CrcVmeAddress.hal");
  VMEAddressTable addressTable("CRC VME Address Table",addressTableReader);

  try{
    DaqBusAdapter busAdapter(pciNumber);
    cout << "PCI card " << pciNumber << " is alive" << endl;
    
    CrcVmeDevice dev(addressTable,busAdapter,slotNumber);
    if(dev.alive()) {
      cout << "  CRC at slot "
	   << setw(2) << slotNumber << " is alive" << endl;

      std::cout << std::endl << "Writing 1 to SystemAceBusModeReg" << std::endl;  
      dev.write("SystemAceBusModeReg",1);
      dev.systemAcePrint(std::cout);

      std::cout << std::endl << "Resetting 2" << std::endl;  
      dev.write("SystemAceControlRegLSBs",0x00);
      dev.write("SystemAceControlRegLSBs",0x20);
      sleep(5);
      dev.systemAcePrint(std::cout);

      std::cout << std::endl << "Resetting 1" << std::endl;  
      dev.write("SystemAceControlRegLSBs",0x10);
      dev.write("SystemAceControlRegLSBs",0x90);
      sleep(5);
      dev.systemAcePrint(std::cout);
      /*
      std::cout << std::endl << "Resetting 3" << std::endl;  
      dev.write("SystemAceControlRegLSBs",0x00);
      dev.write("SystemAceControlRegLSBs",0x1000);
      sleep(5);
      dev.systemAcePrint(std::cout);
      */

      std::cout << std::endl;
      dev.write("SystemAceControlRegLSBs",0x00);
      sleep(5);      
      dev.systemAcePrint(std::cout);
    }    
    return 0;
    
  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << " I Made This" << endl;
    return 0;
    
  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
    return 0;
  }
}
