#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <iostream>
#include <sstream>
#include <vector>
#include <cstdio>

#include "DaqBusAdapter.hh"

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "HardwareAccessException.hh"

#include "BmlLc1176VmeDevice.hh"
#include "BmlCaen767VmeDevice.hh"

using namespace std;

int main(int argc, const char **argv) {

  HAL::VMEAddressTableASCIIReader addressTableReader0("online/hal/Lc1176VmeAddress.hal");
  HAL::VMEAddressTable addressTable0("LC1176 VME Address Table",addressTableReader0);
  HAL::VMEAddressTableASCIIReader addressTableReader1("online/hal/Caen767VmeAddress.hal");
  HAL::VMEAddressTable addressTable1("CAEN767 VME Address Table",addressTableReader1);

  for(unsigned p(0);p<2;p++) {
    try{
      DaqBusAdapter busAdapter(p);
      cout << "PCI card " << p << " is alive" << endl;
      
      for(unsigned i(0);i<256;i++) {
	BmlLc1176VmeDevice dev(addressTable0,busAdapter,i);
	dev.write("CSR",0x00800000);
	dev.reset();
	dev.clear();
	if(dev.alive()) cout << "  LC1176  at address 0x00"
			     << setw(2) << hex << i << dec << "0000 is alive" << endl;
	//else cout << "  LC1176 at address 0x"
	//		     << setw(2) << hex << i << dec << "0000 is NOT alive" << endl;
      }

      //for(unsigned i(0);i<65536;i++) {
      for(unsigned i(0);i<256;i++) {
	unsigned short add(0xca00+i);
	BmlCaen767VmeDevice dev(addressTable1,busAdapter,add);
	if(dev.alive()) cout << "  CAEN767 at address 0x"
			     << setw(4) << std::setfill('0') << hex
			     << add << dec << "0000 is alive" << std::setfill(' ') << endl;
      }


    } catch ( HAL::HardwareAccessException& e ) {
      //cout << "*** Exception occurred : " << endl;
      //cout << e.what() << " I Made This" << endl;
      
    } catch ( exception e ) {
      //cout << "*** Unknown exception occurred" << endl;
    }
  }
}
