#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CercVmeSerialCommandBit.hh"
#include "CercVmeDevice.hh"
#include "SlwCercReadout.hh"
#include "RcdArena.hh"
#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdWriterAsc.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"

bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);


  unsigned numberOfCercs(1);
  unsigned *addressOfCerc(new unsigned[numberOfCercs]);
  addressOfCerc[0]=7;

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCercs << endl;
    CercVmeDevice *CercVMECard[20];
    for(unsigned i(0);i<numberOfCercs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCerc[i] << dec << endl;
      CercVMECard[i]=new CercVmeDevice(addressTable,busAdapter,addressOfCerc[i]);
    }

    //CercVmeDevice CercVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    string item, name;
    unsigned long nCard;
    vector<string> names;

    nCard=0;

    unsigned t,d,x(0);
    std::string w;


    cout << "Target: ";
    if(argh.isArgument(0)) {
      t=argh.argument(0,1);
      cout << t << endl;
    } else {
      cin >> t;
    }

    cout << "Designator: ";
    if(argh.isArgument(1)) {
      d=argh.argument(1,9);
      cout << d << endl;
    } else {
      cin >> d;
    }

    cout << "Write or read: ";
    if(argh.isArgument(2)) {
      w=argh.argument(2,"w");
      cout << w << endl;
    } else {
      cin >> w;
    }

    if(w=="w" || w=="W") {
      cout << "Data: ";
      if(argh.isArgument(3)) {
	x=argh.argument(3,0);
	cout << x << endl;
      } else {
	cin >> x;
      }
    }

    CercVmeSerialCommandBit cvscw((CercVmeSerialHeader::Target)t,(CercSerialHeader::Designator)d);
    cvscw.bit(x);

    cout << endl << "Serial command being sent" << endl;
    cvscw.print(cout);
    //cout << "SENT DATA: T:" << t << "  D: " << d << ", " << x << "  " << w;
    cout << endl;

    if(w=="w" || w=="W") {
      CercVMECard[nCard]->serialWrite(&cvscw);
    } else {
      CercVMECard[nCard]->serialRead(&cvscw);
      cout << endl << "Serial command replied" << endl;
      cvscw.print(cout);    
      
      //cout << "                                      " << 
      //     "READ DATA: T:" << t << "  D: " << d << ", " << cvscw.bit();
      //cout << endl;
    }

  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << "I Made This" << endl;

  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  return 0;
}
