#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>

#include <cstdio>
#include <vector>
#include <string>
#include <iomanip>
#include <iostream>

#include "VMEAddressTable.hh"
#include "VMEAddressTableASCIIReader.hh"
#include "SBS620x86LinuxBusAdapter.hh"
//#include "VMEDummyBusAdapter.hh"
#include "HardwareAccessException.hh"

#include "CrcSerialCommandFeAddress.hh"
#include "CrcSerialCommandWord.hh"
#include "CrcVmeDevice.hh"
#include "CrcBeConfigurationData.hh"
#include "CrcBeTrgRunData.hh"
#include "CrcLm82StartupData.hh"
#include "CrcLm82SetupData.hh"
#include "CrcLm82SlowControlsData.hh"
#include "CrcVlinkEventData.hh"
//#include "SlwCercReadout.hh"
#include "RcdArena.hh"
#include "UtlTime.hh"
#include "UtlArguments.hh"
#include "RcdWriterAsc.hh"

using std::cin;
using std::exception;
using namespace std;

#define CERCVMEADDRESSTABLE "CercAddressMap.dat"
#define SEQUENCE_SETTINGS "Sequences.dat"

bool continueJob=true;

void signalHandler(int signal) {
  std::cout << "Process " << getpid() << " received signal "
            << signal << std::endl;
  continueJob=false;
}


int main(int argc, const char **argv) {
  UtlArguments argh(argc,argv);


  unsigned numberOfCrcs(1);
  unsigned *addressOfCrc(new unsigned[numberOfCrcs]);
  addressOfCrc[0]=6;

  try {
    // if you want to play with real hardware you need a real busAdapter:
    // change the comments below:
    // MXI2x86LinuxBusAdapter busAdapter(0);
    SBS620x86LinuxBusAdapter busAdapter(0);
    // VMEDummyBusAdapter busAdapter;

    VMEAddressTableASCIIReader addressTableReader( CERCVMEADDRESSTABLE );
    VMEAddressTable addressTable( "Test address table", addressTableReader );

    if(addressTable.exists("SerialRead")) cout << "exists" << endl;
    else                                  cout << "non-exists" << endl;

    cout << "Number of CERCs = " << numberOfCrcs << endl;
    CrcVmeDevice *CrcVMECard[20];
    for(unsigned i(0);i<numberOfCrcs;i++) {
      cout << "Address of CERC[" << i << "] = " 
	   << hex << addressOfCrc[i] << dec << endl;
      CrcVMECard[i]=new CrcVmeDevice(addressTable,busAdapter,addressOfCrc[i]);
    }

    //CrcVmeDevice CrcVMECard(addressTable, busAdapter, CERCVME_BASEADDRESS);
    
    //PersistentCommandSequencer sequencer( SEQUENCE_SETTINGS, addressTable );

    string item, name;
    unsigned long nCard;
    vector<string> names;
    
    nCard=0;

    unsigned char feMask(0xff);
    cout << "FE mask = " << printHex(feMask) << endl << endl;
    
    //std::string w;
    
    assert(CrcVMECard[nCard]->reset());
    assert(CrcVMECard[nCard]->beSoftReset());
    assert(CrcVMECard[nCard]->beTrgSoftReset());
    assert(CrcVMECard[nCard]->feSoftReset());
    sleep(1);
    cout << "Soft resets OK" << endl << endl;

    /////////////////////////////////////////////////////////////////

    CrcBeRunData ber;
    assert(CrcVMECard[nCard]->readBeRunData(ber));
    ber.print(cout);
    cout << endl;
    
    CrcBeTrgRunData ter;
    assert(CrcVMECard[nCard]->readBeTrgRunData(ter));
    ter.print(cout);
    cout << endl;
    
    CrcFeRunData fer;
    for(unsigned f(0);f<8;f++) {
      if((feMask&(1<<f))!=0) {
	CrcLocation::CrcComponent fe((CrcLocation::CrcComponent)f);
	assert(CrcVMECard[nCard]->readFeRunData(fe,fer));
	cout << "FE" << f << ": ";
	fer.print(cout);
	cout << endl;
      }
    }

    /////////////////////////////////////////////////////////////////

    CrcBeConfigurationData wBec,rBec;
    wBec.triggerSelect(0x04);
    //wBec.mode(0x01); // Scope
    wBec.mode(0x02); // Frame finding
    wBec.readoutControl(0x02);
    wBec.runControl(0x03);
    //wBec.test(0x0); // Standard Vlink
    wBec.test(0x04); // Counter Vlink test
    //wBec.test(0x08); // Pattern Vlink test
    wBec.feDataEnable(feMask);
    wBec.feTriggerEnable(feMask);
    wBec.testLength(40);
    wBec.daqId(0xcec);
    wBec.print(cout);
    assert(CrcVMECard[nCard]->writeBeConfigurationData(wBec));

    assert(CrcVMECard[nCard]->readBeConfigurationData(rBec));
    rBec.print(cout);
    cout << endl;
    
    CrcBeTrgConfigurationData wTec,rTec;
    wTec.print(cout);
    //assert(CrcVMECard[nCard]->writeBeTrgConfigurationData(wTec));
    
    //assert(CrcVMECard[nCard]->readBeTrgConfigurationData(rTec));
    rTec.print(cout);
    cout << endl;

    CrcFeConfigurationData wFec,rFec;
    unsigned wArray[513],rArray[513];
    CrcFeFakeEventData *wFek((CrcFeFakeEventData*)wArray),
                       *rFek((CrcFeFakeEventData*)rArray);

    for(unsigned f(0);f<8;f++) {
      if((feMask&(1<<f))!=0) {
	CrcLocation::CrcComponent fe((CrcLocation::CrcComponent)f);

	unsigned nadc=18;
	wFec.holdDuration(nadc*4*700);
	wFec.vfeMplexClockPulses(nadc);
	wFec.vfeTopGain(true);
	wFec.vfeBotGain(true);
	wFec.adcControl(9);
	wFec.dacData(0,0);
	wFec.dacData(1,0);
	wFec.frameSyncDelay(128);
	wFec.qdrDataDelay(2);
	cout << "FE" << f << ": ";
	wFec.print(cout);
	cout << endl;
	assert(CrcVMECard[nCard]->writeFeConfigurationData(fe,wFec));

	assert(CrcVMECard[nCard]->readFeConfigurationData(fe,rFec));
	cout << "FE" << f << ": ";
	rFec.print(cout);
	cout << endl;


	wFek->numberOfWords(4);
	wFek->enable(true);
	for(unsigned i(0);i<wFek->numberOfWords();i++) {
	  if((i%2)==0) wArray[i+1]=(~((0xaa00+i)<<16))&0xffff0000|(0xaa00+i);
	  else         wArray[i+1]=(~((0x5500+i)<<16))&0xffff0000|(0x5500+i);
	}
	cout << "FE" << f << ": ";
	wFek->print(cout);
	cout << endl;
	assert(CrcVMECard[nCard]->writeFeFakeEventData(fe,*wFek));

	assert(CrcVMECard[nCard]->readFeFakeEventData(fe,*rFek));
	cout << "FE" << f << ": ";
	rFek->print(cout);
	cout << endl;
      }
    }


    assert(CrcVMECard[nCard]->beSoftReset());

    CrcBeEventData bee;
    assert(CrcVMECard[nCard]->readBeEventData(bee));
    bee.print(cout);
    cout << endl;
    
    unsigned teeArray[CrcBeTrgEventData::maxWordLength];
    CrcBeTrgEventData *tee((CrcBeTrgEventData*)&teeArray);
    CrcVMECard[nCard]->readBeTrgEventData(*tee); // Not assert because of FIFO!
    tee->print(cout);
    cout << endl;
    
    CrcFeEventData fee;
    for(unsigned f(0);f<8;f++) {
      if((feMask&(1<<f))!=0) {
	CrcLocation::CrcComponent fe((CrcLocation::CrcComponent)f);
	assert(CrcVMECard[nCard]->readFeEventData(fe,fee));
	cout << "FE" << f << ": ";
	fee.print(cout);
	cout << endl;
      }
    }


    unsigned *p = new unsigned[1024*1024*32];
    CrcVlinkEventData *v((CrcVlinkEventData*)p);

    for(unsigned e(0);e<1;e++) {

      const unsigned nTrg(16);
      cout << "Sending " << nTrg << " soft triggers" << endl;

      for(unsigned i(0);i<nTrg;i++) {
	assert(CrcVMECard[nCard]->clearBeTrgTrigger());
	
	assert(CrcVMECard[nCard]->beTrgSoftTrigger());
	//assert(CrcVMECard[nCard]->beSoftTrigger());
	//assert(CrcVMECard[nCard]->feSoftTrigger(CrcLocation::fe0));
	
	//assert(false);
	
	assert(CrcVMECard[nCard]->readBeEventData(bee));
	bee.print(cout);
	cout << endl;
	
	assert(CrcVMECard[nCard]->readBeTrgEventData(*tee));
	tee->print(cout);
	cout << endl;
	
	for(unsigned f(0);f<8;f++) {
	  if((feMask&(1<<f))!=0) {
	    CrcLocation::CrcComponent fe((CrcLocation::CrcComponent)f);
	    assert(CrcVMECard[nCard]->readFeEventData(fe,fee));
	    cout << "FE" << f << ": ";
	    fee.print(cout);
	    cout << endl;
	  }
	}
      }
      
      // *** matt
      sleep(1);
      unsigned n(1);

      //while(true) {
      while(n>0) {
	//n=CrcVMECard[nCard]->vlinkRead(p);
	CrcVMECard[nCard]->vlinkRead(*v);
	v->print(cout);

	n=v->numberOfWords();
	//if(n>0) 
	cout << "Number of Vlink words = " << n << endl;
	
	for(unsigned i(0);i<n;i++) {
	  if(p[i]!=0xffffffff)
	    cout << " Vlink word " << setw(4) << i << " = "
		 << printHex(p[i]) << endl;
	}
      }
    }
    
    
  } catch ( HardwareAccessException& e ) {
    cout << "*** Exception occurred : " << endl;
    cout << e.what() << " I Made This" << endl;
    
  } catch ( exception e ) {
    cout << "*** Unknown exception occurred" << endl;
  }
  return 0;
}
