#ifndef SceSlowTemperatureData_HH
#define SceSlowTemperatureData_HH

#include <string>
#include <iostream>


class SceSlowTemperatureData {

public:
  enum {
    versionNumber=0
  };

  SceSlowTemperatureData();

  bool parse(std::string r);
  
  time_t timeStamp() const;
  void   timeStamp(time_t t);

  std::vector<double> getTemperatures() const;

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  time_t _timeStamp;
  double _temperatures[8];
};


#ifdef CALICE_DAQ_ICC

#include <time.h>
#include <cstring>


SceSlowTemperatureData::SceSlowTemperatureData() {
  memset(this,0,sizeof(SceSlowTemperatureData));
}

bool SceSlowTemperatureData::parse(std::string r) {
  memset(this,0,sizeof(SceSlowTemperatureData));
  _timeStamp=0xffffffff;

  std::istringstream sin(r);
  if(!sin) return false;

  sin >> _timeStamp;
  if(!sin) return false;

  for(unsigned i(0);i<8;i++) {
    sin >> _temperatures[i];
    if(!sin) return false;
  }

  return true;
}

time_t SceSlowTemperatureData::timeStamp() const {
  return _timeStamp;
}

void SceSlowTemperatureData::timeStamp(time_t t) {
  _timeStamp=t;
}

std::vector<double> SceSlowTemperatureData::getTemperatures() const {
  std::vector<double> v;

  for(unsigned i(0);i<8;i++) {
    v.push_back(_temperatures[i]);
  }
  
  return v;
}

std::ostream& SceSlowTemperatureData::print(std::ostream &o, std::string s) const {
  o << s << "SceSlowTemperatureData::print()" << std::endl;

  o << s << " Timestamp = " << _timeStamp << " = " << ctime(&_timeStamp);

  for(unsigned i(0);i<8;i++) {
    o << s << " Temperature (voltage) " << i << " = " << std::setw(5)
      << _temperatures[i] << " V" << std::endl;
  }

  return o;
}

#endif
#endif
